package org.havi.ui.event;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */

import java.util.EventListener;

/**
   The {@link org.havi.ui.event.HItemListener
   HItemListener} interface enables the reception of {@link
   org.havi.ui.event.HItemEvent HItemEvents}, as generated
   by objects implementing {@link org.havi.ui.HItemValue
   HItemValue}.
    
  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>
   
*/

public interface HItemListener 
    extends java.util.EventListener
{
    /**
     * Called when a change to the selection mode or the set of selected items
     * held by the {@link org.havi.ui.HItemValue HItemValue} occurs.
     * 
     * @param e is the {@link org.havi.ui.event.HItemEvent
     * HItemEvent} generated by the object implementing {@link
     * org.havi.ui.HItemValue HItemValue}.
     */
    public abstract void selectionChanged(org.havi.ui.event.HItemEvent e);

    /**
     * Called when a change to the current item of the {@link
     * org.havi.ui.HItemValue HItemValue} occurs.
     * 
     * @param e is the {@link org.havi.ui.event.HItemEvent
     * HItemEvent} generated by the object implementing {@link
     * org.havi.ui.HItemValue HItemValue}.
     */
    public abstract void currentItemChanged(org.havi.ui.event.HItemEvent e);    

}


