package org.havi.ui.event;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */

import java.util.EventListener;

/**
   The {@link org.havi.ui.event.HAdjustmentListener
   HAdjustmentListener} interface enables the reception of {@link
   org.havi.ui.event.HAdjustmentEvent HAdjustmentEvents}, as generated
   by objects implementing {@link org.havi.ui.HAdjustmentValue
   HAdjustmentValue}.
    
  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>
   
*/

public interface HAdjustmentListener 
    extends java.util.EventListener
{
    /**
     * Called when the value of the component has started to be
     * changed, is changed, or has finished changing.
     * 
     * @param e is the {@link org.havi.ui.event.HAdjustmentEvent
     * HAdjustmentEvent} generated by the object implementing {@link
     * org.havi.ui.HAdjustmentValue HAdjustmentValue}.
     */
    public abstract void valueChanged(org.havi.ui.event.HAdjustmentEvent e);

}

