package org.havi.ui.event;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */


import java.awt.AWTEvent;
import org.havi.ui.HAdjustmentValue;

/**
   An {@link org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} event is used to
   interact with a component implementing the {@link
   org.havi.ui.HAdjustmentValue HAdjustmentValue} interface as follows:

   <p><ul>

   <li> An {@link org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} event may be sent
   from the HAVi system to the component to cause a change to the
   value or editable mode of the component as a result of user
   interaction. For example, this event may be generated by a virtual
   keyboard user interface on a platform which lacks suitable
   adjustment keys.

   <li> An {@link org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} event is sent from
   the component to all registered {@link
   org.havi.ui.event.HAdjustmentListener HAdjustmentListeners} when a
   change to the value or editable mode of the component occurs.
   
   </ul><p>

   All interoperable HAVi components which expect to receive {@link
   org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} events should also implement the
   {@link org.havi.ui.HAdjustmentInputPreferred
   HAdjustmentInputPreferred} interface.

  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>

*/

public class HAdjustmentEvent 
    extends java.awt.AWTEvent
{

    /**
     * The first integer id in the range of event ids supported by
     * the {@link org.havi.ui.event.HAdjustmentEvent
     * HAdjustmentEvent} class.  
     */
    public static final int ADJUST_FIRST = RESERVED_ID_MAX + 1;
    
    /**
     * The last integer id in the range of event ids supported by
     * the {@link org.havi.ui.event.HAdjustmentEvent
     * HAdjustmentEvent} class.  
     */
    public static final int ADJUST_LAST = ADJUST_FIRST + 5;
    
    /**
     * An adjustment event with this id indicates that the value of an
     * {@link org.havi.ui.HAdjustmentValue HAdjustmentValue} component
     * may be about to change. This event is sent when the user causes
     * the component to enter its editable mode. Note that it is a
     * platform specific implementation option for such components to
     * enter editable mode automatically e.g. when they receive input
     * focus. In such a case the order in which the {@link
     * org.havi.ui.event.HFocusEvent HFocusEvent} and {@link
     * org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} are sent
     * is platform specific.
     * 
     * @see HAdjustmentValue#getAdjustMode 
     */
    public static final int ADJUST_START_CHANGE = ADJUST_FIRST;

    /**
     * An adjustment event with this id is sent whenever the
     * value of an {@link org.havi.ui.HAdjustmentValue
     * HAdjustmentValue} component is decreased by one unit.
     * 
     * @see HAdjustmentValue#setUnitIncrement
     * @see HAdjustmentValue#getUnitIncrement
     */
    public static final int ADJUST_LESS = ADJUST_FIRST + 1;

    /**
     * An adjustment event with this id is sent whenever the
     * value of an {@link org.havi.ui.HAdjustmentValue
     * HAdjustmentValue} component is increased by one unit.
     * 
     * @see HAdjustmentValue#setUnitIncrement
     * @see HAdjustmentValue#getUnitIncrement
     */
    public static final int ADJUST_MORE = ADJUST_FIRST + 2;
    
    /**
     * An adjustment event with this id is sent whenever the
     * value of an {@link org.havi.ui.HAdjustmentValue
     * HAdjustmentValue} component is decreased by one block.
     * 
     * @see HAdjustmentValue#setBlockIncrement
     * @see HAdjustmentValue#getBlockIncrement
     */
    public static final int ADJUST_PAGE_LESS = ADJUST_FIRST + 3;

    /**
     * An adjustment change event with this id is sent whenever the
     * value of an {@link org.havi.ui.HAdjustmentValue
     * HAdjustmentValue} component is increased by one block.
     * 
     * @see HAdjustmentValue#setBlockIncrement
     * @see HAdjustmentValue#getBlockIncrement
     */
    public static final int ADJUST_PAGE_MORE = ADJUST_FIRST + 4;
    
    /**
     * An adjustment event with this id indicates that the value of an
     * {@link org.havi.ui.HAdjustmentValue HAdjustmentValue} component
     * has been finally set. This event is sent when the user causes
     * the component to leave its editable mode. Note that it is a
     * platform specific implementation option for such components to
     * leave editable mode automatically e.g. when they lose input
     * focus. In such a case the order in which the {@link
     * org.havi.ui.event.HFocusEvent HFocusEvent} and {@link
     * org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} are sent
     * is platform specific.
     * 
     * @see HAdjustmentValue#getAdjustMode 
     */
    public static final int ADJUST_END_CHANGE = ADJUST_FIRST + 5;

    /**
     * Constructs an {@link org.havi.ui.event.HAdjustmentEvent
     * HAdjustmentEvent}.
     * 
     * @param source The {@link org.havi.ui.HAdjustmentInputPreferred 
     * HAdjustmentInputPreferred} component whose value has been modified.
     * @param id The event id of the {@link
     * org.havi.ui.event.HAdjustmentEvent HAdjustmentEvent} generated
     * by the 
     * {@link org.havi.ui.HAdjustmentInputPreferred HAdjustmentInputPreferred}
     * component. This is the value that will be returned by the
     * event object's <code>getID</code> method.  
     */
    public HAdjustmentEvent(org.havi.ui.HAdjustmentInputPreferred source, int id)
    {
	super(source, id);
    }

}

