package org.havi.ui;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */

/**
   This class describes a configuration of a screen device in terms of
   various properties and their importance to the application.  It is
   used to request a valid instance of a configuration conforming to
   the description provided. Sub-classes of this define additional
   constants which may be used for additional properties. Those
   classes can be sub-classed in turn to add further properties by
   systems using the HAVi UI.

   <p> 
   In the event of conflicting preferences between
   HScreenConfigTemplates (for example where a configuration is
   requested which conflicts with an existing configuration) the
   following rules shall be applied in all cases. 

   <p><ul>
   
   <li> Where all the conflicting preferences have priority {@link
   HScreenConfigTemplate#PREFERRED}, {@link
   HScreenConfigTemplate#PREFERRED_NOT} or {@link
   HScreenConfigTemplate#DONT_CARE}, the conflicting
   preferences shall be discarded from the template.
   
   <li> Where all the conflicting preferences have priority {@link
   HScreenConfigTemplate#REQUIRED} or {@link
   HScreenConfigTemplate#REQUIRED_NOT}, the method
   concerned shall fail.

   <li> In situations other than the above, all preferences with
   priority {@link HScreenConfigTemplate#PREFERRED}, {@link
   HScreenConfigTemplate#PREFERRED_NOT} or {@link
   HScreenConfigTemplate#DONT_CARE} shall be discarded. If
   there is still a conflict after this, the method concerned shall fail.
     
 </ul>

  <p>

  Several preferences in this class are required to be not filled in
  by the platform in templates generated by the platform. This shall
  mean:
  <ul>
    <li>the object for this preference (if there is one) is set to
      <code>null</code></li>
    <li>the priority for this preference is set to DONT_CARE</li>
  </ul>

  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>

   @see HBackgroundConfigTemplate
   @see HGraphicsConfigTemplate
   @see HVideoConfigTemplate

 */

public abstract class HScreenConfigTemplate
{    
    /**
     * A value for use in the priority field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority}
     * methods in the {@link
     * org.havi.ui.HScreenConfigTemplate} that
     * indicates that this feature is required in the {@link
     * org.havi.ui.HScreenConfiguration}.  If
     * this feature is not available, do not select the {@link
     * org.havi.ui.HScreenConfiguration} object.  
     */
    public static final int REQUIRED                     = 0x01;

    /**
     * A value for use in the priority field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}
     * and {@link org.havi.ui.HScreenConfigTemplate#getPreferencePriority}
     * methods in the {@link
     * org.havi.ui.HScreenConfigTemplate} that
     * indicates that this feature is desired in the {@link
     * org.havi.ui.HScreenConfiguration}.  A
     * selection with this feature is preferred over a selection that
     * does not include this feature, although both selections can be
     * considered valid matches.  
     */
    public static final int PREFERRED                    = 0x02;

    /**
     * A value for use in the priority field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority}
     * methods in the {@link
     * org.havi.ui.HScreenConfigTemplate} that
     * indicates that the presence or absence of this feature in the
     * {@link org.havi.ui.HScreenConfiguration}
     * does not matter. Preferences with this priority play no part in
     * the selection procedure. 
     */
    public static final int DONT_CARE                    = 0x03;

    /**
     * A value for use in the priority field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}
     * and {@link org.havi.ui.HScreenConfigTemplate#getPreferencePriority}
     * methods in the {@link
     * org.havi.ui.HScreenConfigTemplate} that
     * indicates that this feature is desired not to be present in the
     * {@link org.havi.ui.HScreenConfiguration}.
     * A selection without this feature is
     * preferred over a selection that does not include this feature,
     * although both selections can be considered valid matches.  
     */
    public static final int PREFERRED_NOT                = 0x04;

    /**
     * A value for use in the priority field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}
     * and {@link org.havi.ui.HScreenConfigTemplate#getPreferencePriority}
     * methods in the {@link
     * org.havi.ui.HScreenConfigTemplate} that
     * indicates that this feature is required not to be present in
     * the {@link org.havi.ui.HScreenConfiguration}.
     * If this feature is available, do not
     * select the {@link org.havi.ui.HScreenConfiguration} object.  
     */
    public static final int REQUIRED_NOT                 = 0x05;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration should have zero impact
     * on already displayed backgrounds. If used with the {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED REQUIRED} priority,
     * this means no changes shall be made. If used with the {@link
     * HScreenConfigTemplate#PREFERRED PREFERRED} priority, this means
     * changes may be made but should be minimized.
     * <p> 
     * The {@link org.havi.ui.HScreenConfigTemplate#PREFERRED_NOT
     * PREFERRED_NOT} and {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED_NOT REQUIRED_NOT}
     * priorities may be ignored in the selection of an {@link
     * org.havi.ui.HScreenConfiguration HScreenConfiguration} for this
     * preference type.  
     * <p>
     * This preference is used by the platform as a constraint in
     * selecting configurations. Templates generated by the platform
     * and then returned to applications (e.g. from a
     * <code>getConfigTemplate</code> method) shall not have this
     * preference filled in by the platform.  */
    public static final int ZERO_BACKGROUND_IMPACT = 0x01;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration should have zero impact
     * on already running graphical applications. If used with the
     * {@link org.havi.ui.HScreenConfigTemplate#REQUIRED REQUIRED}
     * priority, this means no changes shall be made. If used with the
     * {@link HScreenConfigTemplate#PREFERRED PREFERRED} priority,
     * this means changes may be made but should be minimized.
     * <p> 
     * The {@link org.havi.ui.HScreenConfigTemplate#PREFERRED_NOT
     * PREFERRED_NOT} and {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED_NOT REQUIRED_NOT}
     * priorities may be ignored in the selection of an {@link
     * org.havi.ui.HScreenConfiguration HScreenConfiguration} for this
     * preference type.  
     * <p>
     * This preference is used by the platform as a constraint in
     * selecting configurations. Templates generated by the platform
     * and then returned to applications (e.g. from a
     * <code>getConfigTemplate</code> method) shall not have this
     * preference filled in by the platform.
     */
    public static final int ZERO_GRAPHICS_IMPACT         = 0x02;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration should have zero impact
     * on already running video streams.  If used with the {@link
     * HScreenConfigTemplate#REQUIRED REQUIRED} priority, this means
     * no changes shall be made. If used with the {@link
     * HScreenConfigTemplate#PREFERRED PREFERRED} priority, this means
     * changes may be made but should be minimized.  <p> The {@link
     * org.havi.ui.HScreenConfigTemplate#PREFERRED_NOT PREFERRED_NOT}
     * and {@link org.havi.ui.HScreenConfigTemplate#REQUIRED_NOT
     * REQUIRED_NOT}.  priorities may be ignored in the selection of
     * an {@link org.havi.ui.HScreenConfiguration
     * HScreenConfiguration} for this preference type.  
     * <p>
     * This preference is used by the platform as a constraint in
     * selecting configurations. Templates generated by the platform
     * and then returned to applications (e.g. from a
     * <code>getConfigTemplate</code> method) shall not have this
     * preference filled in by the platform.
     */
    public static final int ZERO_VIDEO_IMPACT            = 0x03;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports an interlaced
     * display.  
     */
    public static final int INTERLACED_DISPLAY           = 0x04;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference}
     * and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports flicker
     * filtering (if it supports an interlaced screen).  
     */
    public static final int FLICKER_FILTERING            = 0x05;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference},
     * {@link org.havi.ui.HScreenConfigTemplate#getPreferenceObject
     * getPreferenceObject} and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports the display of
     * video streams and graphics with aligned pixels of the same
     * size. Alignment of the origins of the two pixel coordinate
     * spaces is explicitly not required. Where a video device is
     * moving the video relative to the screen in real time (e.g.
     * implementing pan and scan), graphics configurations shall only
     * support this feature where the implementation of the graphics
     * device can track the position changes in the video device
     * automatically.
     * <p> 
     * If this preference is set and used to request an {@link
     * org.havi.ui.HVideoConfiguration HVideoConfiguration} then an
     * {@link org.havi.ui.HGraphicsConfiguration
     * HGraphicsConfiguration} shall be used as the preference object.  If
     * it is set and used to request an {@link
     * org.havi.ui.HGraphicsConfiguration HGraphicsConfiguration} then
     * an {@link org.havi.ui.HVideoConfiguration HVideoConfiguration}
     * shall be used as the preference object. Requesting an {@link
     * org.havi.ui.HVideoConfiguration HVideoConfiguration} which is
     * VIDEO_GRAPHICS_PIXEL_ALIGNED with another {@link
     * org.havi.ui.HVideoConfiguration HVideoConfiguration} shall fail
     * unless the system concerned supports two {@link
     * org.havi.ui.HVideoDevice HVideoDevice} objects which can
     * support this exact feature.  
     * <p>
     * This preference is used by the platform as a constraint in
     * selecting configurations. Templates generated by the platform
     * and then returned to applications (e.g. from a
     * <code>getConfigTemplate</code> method) shall not have this
     * preference filled in by the platform.
     */
    public static final int VIDEO_GRAPHICS_PIXEL_ALIGNED = 0x06;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference},
     * {@link org.havi.ui.HScreenConfigTemplate#getPreferenceObject
     * getPreferenceObject} and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports the pixel
     * aspect ratio, as specified in a Dimension object which
     * indicates the (relative) x, y pixel aspect ratio.  <p>
     * Instances of {@link org.havi.ui.HScreenConfigTemplate
     * HScreenConfigTemplate} generated by the platform and returned
     * to applications (e.g. from {@link
     * org.havi.ui.HGraphicsConfiguration#getConfigTemplate
     * getConfigTemplate} shall have this preference set to a platform
     * specific value with the {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED REQUIRED} priority.  */
    public static final int PIXEL_ASPECT_RATIO           = 0x07;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference},
     * {@link org.havi.ui.HScreenConfigTemplate#getPreferenceObject
     * getPreferenceObject} and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports the pixel
     * resolution, as specified in a Dimension object which indicates
     * the pixel resolution of (the area of) the graphics device (as
     * specified using the {@link
     * org.havi.ui.HScreenConfigTemplate#SCREEN_RECTANGLE
     * SCREEN_RECTANGLE} preference).
     * <p>
     * Instances of {@link org.havi.ui.HScreenConfigTemplate
     * HScreenConfigTemplate} generated by the platform and returned
     * to applications (e.g. from {@link
     * org.havi.ui.HGraphicsConfiguration#getConfigTemplate
     * getConfigTemplate} shall have this preference set to a platform
     * specific value with the {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED REQUIRED} priority.
     */
    public static final int PIXEL_RESOLUTION             = 0x08;

    /**
     * A value for use in the preference field of the {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference setPreference},
     * {@link org.havi.ui.HScreenConfigTemplate#getPreferenceObject
     * getPreferenceObject} and {@link
     * org.havi.ui.HScreenConfigTemplate#getPreferencePriority
     * getPreferencePriority} methods in the {@link
     * org.havi.ui.HScreenConfigTemplate HScreenConfigTemplate} that
     * indicates that the device configuration supports 
     * presentation on a particular on-screen area, as specified in an
     * {@link org.havi.ui.HScreenRectangle HScreenRectangle} object
     * <p>
     * Use of this value with an {@link org.havi.ui.HScreenRectangle
     * HScreenRectangle} object other than the identity rectangle
     * <code>[0, 0 -> 1, 1]</code> implies scaling of the presentation
     * to fit within the specified HScreenRectangle. 
     * <p>
     * Platforms not supporting such scaling at all or choosing to
     * expose such scaling through other APIs should only return
     * {@link org.havi.ui.HScreenConfigTemplate
     * HScreenConfigTemplates} with the {@link
     * org.havi.ui.HScreenRectangle HScreenRectangle} <code>[0, 0 ->
     * 1, 1]</code> for the SCREEN_RECTANGLE preference.  
     * <p>
     * Instances of {@link org.havi.ui.HScreenConfigTemplate
     * HScreenConfigTemplate} generated by the platform and returned
     * to applications (e.g. from {@link
     * org.havi.ui.HGraphicsConfiguration#getConfigTemplate
     * getConfigTemplate} shall have this preference set to a platform
     * specific value with the {@link
     * org.havi.ui.HScreenConfigTemplate#REQUIRED REQUIRED} priority.
     */
    public static final int SCREEN_RECTANGLE              = 0x09;










    /**
     * Creates an {@link org.havi.ui.HScreenConfigTemplate}
     * object. See the class description
     * for details of constructor parameters and default values.  
     */
    public HScreenConfigTemplate()
    {
    }

    /**
     * Set the indicated preference to have the specified priority. If
     * the preference has been previously set, then the previous
     * priority for the preference shall be overwritten.
     * <p>
     * Attributes that are not filled in a template (through {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}),
     * shall have the priority {@link
     * org.havi.ui.HScreenConfigTemplate#DONT_CARE}. Any
     * configuration always satisfies these attributes.
     *
     * @param preference the preference to be indicated. Valid values
     * for an {@link org.havi.ui.HScreenConfigTemplate} are:
     * {@link org.havi.ui.HScreenConfigTemplate#ZERO_GRAPHICS_IMPACT},
     * {@link org.havi.ui.HScreenConfigTemplate#ZERO_BACKGROUND_IMPACT},
      * {@link org.havi.ui.HScreenConfigTemplate#ZERO_VIDEO_IMPACT},
     * {@link org.havi.ui.HScreenConfigTemplate#INTERLACED_DISPLAY} and
     * {@link org.havi.ui.HScreenConfigTemplate#FLICKER_FILTERING}.
     * <p>
     * Subclasses may add further valid values. An
     * IllegalArgumentException shall be thrown if the preference is
     * not a valid value for this instance of {@link
     * org.havi.ui.HScreenConfigTemplate}
     * @param priority the priority of the preference. Valid values are:
     * {@link org.havi.ui.HScreenConfigTemplate#REQUIRED},
     * {@link org.havi.ui.HScreenConfigTemplate#PREFERRED},
     * {@link org.havi.ui.HScreenConfigTemplate#DONT_CARE},
     * {@link org.havi.ui.HScreenConfigTemplate#PREFERRED_NOT} and
     * {@link org.havi.ui.HScreenConfigTemplate#REQUIRED_NOT}. 
     * <p>
     * If <code>priority</code> is not a valid priority as defined here a 
     * java.lang.IllegalArgumentException will be thrown.  
     */
    public void setPreference(int preference, int priority)
    {
    }

    /**
     * Set the indicated preference (and associated value object) to
     * have the specified priority. If the preference has been
     * previously set, then the previous object and priority shall be
     * overwritten.
     * <p>
     * Attributes that are not filled in a template (through {@link
     * org.havi.ui.HScreenConfigTemplate#setPreference}),
     * shall have the priority {@link
     * org.havi.ui.HScreenConfigTemplate#DONT_CARE}. Any
     * configuration always satisfies these attributes.
     * <p>
     * An application which wishes to remove a preference from an
     * existing template (e.g. one generated by the platform) may call
     * this method with null for the object parameter.
     *
     * @param preference the preference to be indicated. Valid values
     * for an {@link org.havi.ui.HScreenConfigTemplate} are:
     * {@link org.havi.ui.HScreenConfigTemplate#VIDEO_GRAPHICS_PIXEL_ALIGNED},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_ASPECT_RATIO},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_RESOLUTION} and
     * {@link org.havi.ui.HScreenConfigTemplate#SCREEN_RECTANGLE}.
     * <p>
     * Subclasses may add further valid values. An
     * IllegalArgumentException shall be thrown if the preference is
     * not a valid value for this instance of {@link
     * org.havi.ui.HScreenConfigTemplate}
     * @param object the Object associated with the given preference,
     * or <code>null</code>.
     * @param priority the priority of the preference. Valid values include:
     * {@link org.havi.ui.HScreenConfigTemplate#REQUIRED},
     * {@link org.havi.ui.HScreenConfigTemplate#PREFERRED},
     * {@link org.havi.ui.HScreenConfigTemplate#DONT_CARE},
     * {@link org.havi.ui.HScreenConfigTemplate#PREFERRED_NOT} and
     * {@link org.havi.ui.HScreenConfigTemplate#REQUIRED_NOT}.  
     * <p>
     * If <code>priority</code> is not a valid priority as defined here a 
     * java.lang.IllegalArgumentException will be thrown.  
     */
    public void setPreference(int preference, Object object, int priority)
    {
    }

    /**
     * Return the priority for the specified preference.
     * <p>
     * Individual properties in the ConfigTemplate can then be examined using 
     * the getPreferencePriority and getPreferenceObject methods -- features  
     * that are implemented will return {@link HScreenConfigTemplate#REQUIRED},
     * features that are not implemented will return {@link  
     * HScreenConfigTemplate#REQUIRED_NOT}.
     *
     * @param preference the preference to be indicated. Valid values
     * for an {@link org.havi.ui.HScreenConfigTemplate} are:
     * {@link org.havi.ui.HScreenConfigTemplate#ZERO_BACKGROUND_IMPACT},
     * {@link org.havi.ui.HScreenConfigTemplate#ZERO_GRAPHICS_IMPACT},
     * {@link org.havi.ui.HScreenConfigTemplate#ZERO_VIDEO_IMPACT},
     * {@link org.havi.ui.HScreenConfigTemplate#INTERLACED_DISPLAY},
     * {@link org.havi.ui.HScreenConfigTemplate#FLICKER_FILTERING},
     * {@link org.havi.ui.HScreenConfigTemplate#VIDEO_GRAPHICS_PIXEL_ALIGNED},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_ASPECT_RATIO},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_RESOLUTION} and
     * {@link org.havi.ui.HScreenConfigTemplate#SCREEN_RECTANGLE}.
     * <p>
     * Subclasses may add further valid values. An
     * IllegalArgumentException shall be thrown if the preference is
     * not a valid value for this instance of {@link
     * org.havi.ui.HScreenConfigTemplate}
     * @return the priority for the specified preference.  
     */
    public int getPreferencePriority(int preference)
    {
        return (REQUIRED);
    }

    /**
     * Return the preference object for the specified preference.
     * <p>
     * Instances of {@link org.havi.ui.HScreenConfigTemplate}
     * which have not had this preference set
     * shall return null for this object. Note that instances
     * constructed by the platform and returned to applications are
     * required to have all preferences (except where explicitly
     * identified) set by the platform before it is returned.
     *
     * @param preference the preference to be indicated. Valid values
     * for an {@link org.havi.ui.HScreenConfigTemplate} are:
     * {@link org.havi.ui.HScreenConfigTemplate#VIDEO_GRAPHICS_PIXEL_ALIGNED},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_ASPECT_RATIO},
     * {@link org.havi.ui.HScreenConfigTemplate#PIXEL_RESOLUTION} and
     * {@link org.havi.ui.HScreenConfigTemplate#SCREEN_RECTANGLE}.
     * <p>
     * Subclasses may add further valid values. A
     * IllegalArgumentException shall be thrown if the preference is
     * not a valid value for this instance of {@link
     * org.havi.ui.HScreenConfigTemplate}, or
     * if <code>preference</code> does not have an associated value object.
     * @return the preference object for the specified preference.  
     */
    public Object getPreferenceObject(int preference)
    {
        return (null);
    }
}

