/*
 * @(#)ControllerListener.java	1.21 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.media;

/**
 * <CODE>ControllerListener</CODE> is an interface for handling asynchronous
 * events generated by <code>Controllers</code>.
 *
 * <h2>Java Beans Support </h2>
 * If implementations of this interface are going to be used with
 * Java Beans they need to also implement either java.util.EventListener
 * or sunw.util.EventListener.
 *
 *
 * @see Controller
 * 
 * @version 1.21, 98/03/28
 *
 */
public interface ControllerListener {

    /**
     * This method is called when an event is generated by a 
     * <code>Controller</code> that this listener is registered with.
     *
     * @param event The event generated.
     */
    void controllerUpdate(ControllerEvent event);
}
