/*
 * @(#)ControllerEvent.java	1.14 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.media;

/**
 * <code>ControllerEvent</code> is the base class for events generated by
 * a <CODE>Controller</CODE>.
 *
 * These events are used by <CODE>ControllerListener</CODE>.
 *
 * <h2>Java Beans Compatibility</h2>
 * This class is designed to support the Java Beans event model.
 * In order to enable 
 * 
 * @see Controller
 * @see ControllerListener
 * @see MediaEvent
 * @version 1.14, 98/03/28
 */

public class ControllerEvent extends java.util.EventObject
                             implements MediaEvent {

    Controller eventSrc;

    public ControllerEvent(Controller from) {
	super(from);
	eventSrc = from;
    }

    /**
     * Get the <CODE>Controller</CODE> that posted this event.  
     * The returned <CODE>Controller</CODE> has at least one active
     * listener. (The 
     * <CODE>addListener</CODE> method has been called on
     * the <CODE>Controller</CODE>).
     * 
     * @return The <CODE>Controller</CODE> that posted this event.
     */
    public Controller getSourceController() {
	return eventSrc;
    }

    public Object getSource() {
	return eventSrc;
    }

    /**
     * Returns the String representation of this event's values.
     */
    public String toString() {
	return getClass().getName() + "[source=" + eventSrc + "]";
    }
}
