/*
 * @(#)CachingControlEvent.java	1.12 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package javax.media;

/**
 * This event is generated by a <CODE>Controller</CODE> that supports
 * the <code>CachingControl</code> interface.  It is posted when the caching 
 * state changes.
 *
 * @see Controller
 * @see ControllerListener
 * @see CachingControl
 * @version 1.12, 98/03/28.
 */
public class CachingControlEvent extends ControllerEvent {

    CachingControl control;
    long progress;
    
    /**
     * Construct a <CODE>CachingControlEvent</CODE> from the required elements.
     */
    public CachingControlEvent(Controller from, CachingControl cacheControl,
			       long progress) {
	super(from);
	control = cacheControl;
	this.progress = progress;
    }

    /**
     * Get the <code>CachingControl</code> object that generated
     * the event.
     *
     * @return The <code>CachingControl</code> object.
     */

    public CachingControl getCachingControl() {
	return control;
    }
    
    /**
     * Get the total number of bytes of media data that have been downloaded so far.
     *
     * @return The number of bytes of media data downloaded.
    */
    public long getContentProgress() {
	return progress;
    }

    /**
     * Returns the String representation of this event's values.
     */
    public String toString() {
	return getClass().getName() + "[source=" + eventSrc + 
	    ",cachingControl=" + control + 
	    ",progress=" + progress + "]";
    }
}
