/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;

public final class BitCounter32
implements BitmapStorage32 {
    private int oneBits;

    @Override
    public void addWord(int newData) {
        this.oneBits += Integer.bitCount(newData);
    }

    @Override
    public void addLiteralWord(int newData) {
        this.oneBits += Integer.bitCount(newData);
    }

    @Override
    public void addStreamOfLiteralWords(int[] data, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addLiteralWord(data[i]);
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number) {
        if (v) {
            this.oneBits += number * 32;
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(int[] data, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addLiteralWord(~data[i]);
        }
    }

    @Override
    public void clear() {
        this.oneBits = 0;
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int bits) {
    }
}

