/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class ORIt
implements CloneableIterator<EWAHIterator32> {
    EWAHCompressedBitmap32 buffer = new EWAHCompressedBitmap32();
    int[] hardbitmap;
    LinkedList<IteratingRLW32> ll;

    ORIt(LinkedList<IteratingRLW32> basell, int bufsize) {
        this.ll = basell;
        this.hardbitmap = new int[bufsize];
    }

    public XORIt clone() throws CloneNotSupportedException {
        XORIt answer = (XORIt)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (int[])this.hardbitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator32 next() {
        this.buffer.clear();
        int effective = 0;
        Iterator i = this.ll.iterator();
        while (i.hasNext()) {
            IteratingRLW32 rlw = (IteratingRLW32)i.next();
            if (rlw.size() > 0) {
                int eff = IteratorAggregation32.inplaceor(this.hardbitmap, rlw);
                if (eff <= effective) continue;
                effective = eff;
                continue;
            }
            i.remove();
        }
        for (int k = 0; k < effective; ++k) {
            this.buffer.addWord(this.hardbitmap[k]);
        }
        Arrays.fill(this.hardbitmap, 0);
        return this.buffer.getEWAHIterator();
    }
}

