/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.datastructure.PriorityQ;
import com.googlecode.javaewah.symmetric.BitmapSymmetricAlgorithm;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Comparator;

public class RunningBitmapMerge
implements BitmapSymmetricAlgorithm {
    @Override
    public void symmetric(UpdateableBitmapFunction f, BitmapStorage out, EWAHCompressedBitmap ... set) {
        out.clear();
        PriorityQ<EWAHPointer> H = new PriorityQ<EWAHPointer>(set.length, new Comparator<EWAHPointer>(){

            @Override
            public int compare(EWAHPointer arg0, EWAHPointer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        f.resize(set.length);
        for (int k = 0; k < set.length; ++k) {
            EWAHPointer x = new EWAHPointer(0, new IteratingBufferedRunningLengthWord(set[k]), k);
            if (x.hasNoData()) continue;
            f.rw[k] = x;
            x.callbackUpdate(f);
            H.toss(x);
        }
        H.buildHeap();
        int lasta = 0;
        if (H.isEmpty()) {
            return;
        }
        block1: while (true) {
            int a = H.peek().endOfRun();
            f.dispatch(out, lasta, a);
            lasta = a;
            while (true) {
                if (H.peek().endOfRun() != a) continue block1;
                EWAHPointer p = H.peek();
                p.parseNextRun();
                p.callbackUpdate(f);
                if (p.hasNoData()) {
                    H.poll();
                    if (!H.isEmpty()) continue;
                    break block1;
                }
                H.percolateDown();
            }
            break;
        }
    }
}

