/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.RunningLengthWord;

public final class EWAHIterator
implements Cloneable {
    protected int pointer;
    protected RunningLengthWord rlw;
    protected int size;

    public EWAHIterator(EWAHCompressedBitmap a, int sizeInWords) {
        this.rlw = new RunningLengthWord(a, 0);
        this.size = sizeInWords;
        this.pointer = 0;
    }

    public static EWAHIterator getEWAHIterator(EWAHCompressedBitmap bitmap) {
        return bitmap.getEWAHIterator();
    }

    public long[] buffer() {
        return this.rlw.parent.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator clone() throws CloneNotSupportedException {
        EWAHIterator ans = (EWAHIterator)super.clone();
        ans.rlw = this.rlw.clone();
        ans.size = this.size;
        ans.pointer = this.pointer;
        return ans;
    }
}

