/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.IteratingRLW32;

public class IntIteratorOverIteratingRLW32
implements IntIterator {
    IteratingRLW32 parent;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasnext;

    public IntIteratorOverIteratingRLW32(IteratingRLW32 p) {
        this.parent = p;
        this.position = 0;
    }

    private final boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (this.eatRunningLengthWord()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasnext;
    }

    @Override
    public final int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            int bit = Long.numberOfTrailingZeros(this.word);
            this.word ^= 1L << bit;
            answer = this.literalPosition + bit;
        }
        this.hasnext = this.moveToNext();
        return answer;
    }

    private final boolean eatRunningLengthWord() {
        this.runningLength = 64 * this.parent.getRunningLength() + this.position;
        if (!this.parent.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.parent.getNumberOfLiteralWords();
        this.wordLength = this.wordPosition + this.parent.getNumberOfLiteralWords();
        return this.parent.next();
    }

    private final boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private final boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            this.word = this.parent.getLiteralWordAt(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

