/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import java.text.DecimalFormat;
import java.util.List;

public class benchmark {
    public static void main(String[] args) {
        benchmark.test(100, 16, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 31 - nbr; ++sparsity) {
            int r;
            int k;
            int r2;
            long bogus = 0L;
            String line = "";
            line = line + sparsity;
            int[][] data = new int[N][];
            int Max = 1 << nbr + sparsity;
            System.out.println("# generating random data...");
            for (int k2 = 0; k2 < N; ++k2) {
                data[k2] = cdg.generateClustered(1 << nbr, Max);
            }
            System.out.println("# generating random data... ok.");
            long bef = System.currentTimeMillis();
            EWAHCompressedBitmap[] ewah = new EWAHCompressedBitmap[N];
            int size = 0;
            for (r2 = 0; r2 < repeat; ++r2) {
                size = 0;
                for (k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    size += ewah[k].sizeInBytes();
                }
            }
            long aft = System.currentTimeMillis();
            line = line + "\t" + size;
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    int[] array = ewah[k].toArray();
                    bogus += (long)array.length;
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    int[] array = new int[ewah[k].cardinality()];
                    int c = 0;
                    for (int x : ewah[k]) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    List<Integer> L = ewah[k].getPositions();
                    int[] array = new int[L.size()];
                    int c = 0;
                    for (int x : L) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    IntIterator iter = ewah[k].intIterator();
                    while (iter.hasNext()) {
                        bogus += (long)iter.next();
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap ewahor = ewah[0];
                    for (int j = 1; j < k; ++j) {
                        ewahor = ewahor.or(ewah[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[k];
                    }
                    EWAHCompressedBitmap ewahor = EWAHCompressedBitmap.or(ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap ewahand = ewah[0];
                    for (int j = 1; j < k; ++j) {
                        ewahand = ewahand.and(ewah[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r2 = 0; r2 < repeat; ++r2) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[k];
                    }
                    EWAHCompressedBitmap ewahand = EWAHCompressedBitmap.and(ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            ewah = null;
            line = line + "\t";
            bef = System.currentTimeMillis();
            EWAHCompressedBitmap32[] ewah32 = new EWAHCompressedBitmap32[N];
            int size32 = 0;
            for (r = 0; r < repeat; ++r) {
                size32 = 0;
            }
            for (int k3 = 0; k3 < N; ++k3) {
                ewah32[k3] = new EWAHCompressedBitmap32();
                for (int x = 0; x < data[k3].length; ++x) {
                    ewah32[k3].set(data[k3][x]);
                }
                size32 += ewah32[k3].sizeInBytes();
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + size32;
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k4 = 0; k4 < N; ++k4) {
                    int[] array = ewah32[k4].toArray();
                    bogus += (long)array.length;
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k5 = 0; k5 < N; ++k5) {
                    int[] array = new int[ewah32[k5].cardinality()];
                    int c = 0;
                    for (int x : ewah32[k5]) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k6 = 0; k6 < N; ++k6) {
                    List<Integer> L = ewah32[k6].getPositions();
                    int[] array = new int[L.size()];
                    int c = 0;
                    for (int x : L) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k7 = 0; k7 < N; ++k7) {
                    IntIterator iter = ewah32[k7].intIterator();
                    while (iter.hasNext()) {
                        bogus += (long)iter.next();
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k8 = 0; k8 < N; ++k8) {
                    EWAHCompressedBitmap32 ewahor = ewah32[0];
                    for (int j = 1; j < k8; ++j) {
                        ewahor = ewahor.or(ewah32[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k9 = 0; k9 < N; ++k9) {
                    EWAHCompressedBitmap32[] ewahcp = new EWAHCompressedBitmap32[k9 + 1];
                    for (int j = 0; j < k9 + 1; ++j) {
                        ewahcp[j] = ewah32[k9];
                    }
                    EWAHCompressedBitmap32 ewahor = EWAHCompressedBitmap32.or(ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k10 = 0; k10 < N; ++k10) {
                    EWAHCompressedBitmap32 ewahand = ewah32[0];
                    for (int j = 1; j < k10; ++j) {
                        ewahand = ewahand.and(ewah32[j]);
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k11 = 0; k11 < N; ++k11) {
                    EWAHCompressedBitmap32[] ewahcp = new EWAHCompressedBitmap32[k11 + 1];
                    for (int j = 0; j < k11 + 1; ++j) {
                        ewahcp[j] = ewah32[k11];
                    }
                    EWAHCompressedBitmap32 ewahand = EWAHCompressedBitmap32.and(ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            ewah32 = null;
            System.out.println(line);
            System.out.println("# bogus =" + bogus);
        }
    }
}

