/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search;

import java.io.Serializable;

public class Sort
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String property;
    protected boolean desc = false;
    protected boolean ignoreCase = false;

    public Sort() {
    }

    public Sort(String property, boolean desc, boolean ignoreCase) {
        this.property = property;
        this.desc = desc;
        this.ignoreCase = ignoreCase;
    }

    public Sort(String property, boolean desc) {
        this.property = property;
        this.desc = desc;
    }

    public Sort(String property) {
        this.property = property;
    }

    public static Sort asc(String property) {
        return new Sort(property);
    }

    public static Sort asc(String property, boolean ignoreCase) {
        return new Sort(property, ignoreCase);
    }

    public static Sort desc(String property) {
        return new Sort(property, true);
    }

    public static Sort desc(String property, boolean ignoreCase) {
        return new Sort(property, true, ignoreCase);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isDesc() {
        return this.desc;
    }

    public void setDesc(boolean desc) {
        this.desc = desc;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.desc ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.desc != other.desc) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.property == null) {
            sb.append("null");
        } else {
            sb.append("`");
            sb.append(this.property);
            sb.append("`");
        }
        sb.append(this.desc ? " desc" : " asc");
        if (this.ignoreCase) {
            sb.append(" (ignore case)");
        }
        return sb.toString();
    }
}

