/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search;

import java.io.Serializable;

public class Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROOT_ENTITY = "";
    protected String property;
    protected String key;
    protected int operator = 0;
    public static final int OP_PROPERTY = 0;
    public static final int OP_COUNT = 1;
    public static final int OP_COUNT_DISTINCT = 2;
    public static final int OP_MAX = 3;
    public static final int OP_MIN = 4;
    public static final int OP_SUM = 5;
    public static final int OP_AVG = 6;

    public Field() {
    }

    public Field(String property) {
        this.property = property;
    }

    public Field(String property, String key) {
        this.property = property;
        this.key = key;
    }

    public Field(String property, int operator) {
        this.property = property;
        this.operator = operator;
    }

    public Field(String property, int operator, String key) {
        this.property = property;
        this.operator = operator;
        this.key = key;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.operator;
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean parens = true;
        switch (this.operator) {
            case 6: {
                sb.append("AVG(");
                break;
            }
            case 1: {
                sb.append("COUNT(");
                break;
            }
            case 2: {
                sb.append("COUNT_DISTINCT(");
                break;
            }
            case 3: {
                sb.append("MAX(");
                break;
            }
            case 4: {
                sb.append("MIN(");
                break;
            }
            case 0: {
                parens = false;
                break;
            }
            case 5: {
                sb.append("SUM(");
                break;
            }
            default: {
                sb.append("**INVALID OPERATOR: (" + this.operator + ")** ");
                parens = false;
            }
        }
        if (this.property == null) {
            sb.append("null");
        } else {
            sb.append("`");
            sb.append(this.property);
            sb.append("`");
        }
        if (parens) {
            sb.append(")");
        }
        if (this.key != null) {
            sb.append(" as `");
            sb.append(this.key);
            sb.append("`");
        }
        return sb.toString();
    }
}

