/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.FileCopyUtils;
import com.googlecode.flyway.core.util.Resource;
import com.googlecode.flyway.core.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemResource
implements Resource,
Comparable<FileSystemResource> {
    private File location;

    public FileSystemResource(String location) {
        this.location = new File(location);
    }

    @Override
    public String getLocation() {
        String path = StringUtils.replaceAll(this.location.getPath(), "\\", "/");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    @Override
    public String getLocationOnDisk() {
        return this.location.getAbsolutePath();
    }

    @Override
    public String loadAsString(String encoding) {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, Charset.forName(encoding));
            return FileCopyUtils.copyToString(reader);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.location.getPath() + " (encoding: " + encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.location.getPath(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.location.getName();
    }

    @Override
    public boolean exists() {
        return this.location.exists();
    }

    @Override
    public int compareTo(FileSystemResource o) {
        return this.location.compareTo(o.location);
    }
}

