/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.QRPDecomposition;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrp
extends LinearSolverAbstract {
    QRPDecomposition<DenseMatrix64F> decomposition;
    DenseMatrix64F Q = new DenseMatrix64F(1, 1);
    DenseMatrix64F R = new DenseMatrix64F(1, 1);
    private DenseMatrix64F Y = new DenseMatrix64F(1, 1);
    private DenseMatrix64F Z = new DenseMatrix64F(1, 1);

    public LinearSolverQrp(QRPDecomposition<DenseMatrix64F> decomposition) {
        this.decomposition = decomposition;
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        if (!this.decomposition.decompose(A)) {
            return false;
        }
        this.Q.reshape(A.numRows, A.numCols, true);
        this.R.reshape(A.numCols, A.numCols, false);
        this.decomposition.getQ(this.Q, true);
        this.decomposition.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(true, this.R);
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        this.Y.reshape(this.numRows, 1, false);
        this.Z.reshape(this.numCols, 1, false);
        int[] pivotTran = new int[this.numCols];
        int[] pivots = this.decomposition.getPivots();
        for (int i = 0; i < this.numCols; ++i) {
            pivotTran[pivots[i]] = i;
        }
        int rank = this.decomposition.getRank();
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.Y.data[i] = B.get(i, colB);
            }
            CommonOps.multTransA(this.Q, this.Y, this.Z);
            TriangularSolver.solveU(this.R.data, this.Z.data, rank);
            for (i = 0; i < rank; ++i) {
                X.set(i, colB, this.Z.data[pivotTran[i]]);
            }
            for (i = rank; i < this.numCols; ++i) {
                X.set(i, colB, B.get(pivotTran[i], colB));
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

