/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.IOException;
import java.util.Random;
import org.ejml.alg.generic.GenericMatrixOps;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixIO;
import org.ejml.ops.RandomMatrices;
import org.ejml.simple.SimpleBase;

public class SimpleMatrix
extends SimpleBase<SimpleMatrix> {
    public static final int END = Integer.MAX_VALUE;

    public SimpleMatrix(int numRows, int numCols, boolean rowMajor, double ... data) {
        this.mat = new DenseMatrix64F(numRows, numCols, rowMajor, data);
    }

    public SimpleMatrix(double[][] data) {
        this.mat = new DenseMatrix64F(data);
    }

    public SimpleMatrix(int numRows, int numCols) {
        this.mat = new DenseMatrix64F(numRows, numCols);
    }

    public SimpleMatrix(SimpleMatrix orig) {
        this.mat = orig.mat.copy();
    }

    public SimpleMatrix(DenseMatrix64F orig) {
        this.mat = orig.copy();
    }

    public SimpleMatrix(Matrix64F orig) {
        this.mat = new DenseMatrix64F(orig.numRows, orig.numCols);
        GenericMatrixOps.copy(orig, this.mat);
    }

    protected SimpleMatrix() {
    }

    public static SimpleMatrix wrap(DenseMatrix64F internalMat) {
        SimpleMatrix ret = new SimpleMatrix();
        ret.mat = internalMat;
        return ret;
    }

    public static SimpleMatrix identity(int width) {
        SimpleMatrix ret = new SimpleMatrix(width, width);
        CommonOps.setIdentity(ret.mat);
        return ret;
    }

    public static SimpleMatrix diag(double ... vals) {
        DenseMatrix64F m = CommonOps.diag(vals);
        SimpleMatrix ret = SimpleMatrix.wrap(m);
        return ret;
    }

    public static SimpleMatrix random(int numRows, int numCols, double minValue, double maxValue, Random rand) {
        SimpleMatrix ret = new SimpleMatrix(numRows, numCols);
        RandomMatrices.setRandom(ret.mat, minValue, maxValue, rand);
        return ret;
    }

    public static SimpleMatrix load(String fileName) throws IOException {
        Object mat = MatrixIO.load(fileName);
        if (mat instanceof DenseMatrix64F) {
            return SimpleMatrix.wrap((DenseMatrix64F)mat);
        }
        return SimpleMatrix.wrap(new DenseMatrix64F((Matrix64F)mat));
    }

    @Override
    protected SimpleMatrix createMatrix(int numRows, int numCols) {
        return new SimpleMatrix(numRows, numCols);
    }
}

