/*
 * Decompiled with CFR 0.152.
 */
package apparat.embedding.maven;

import apparat.log.Debug$;
import apparat.log.Error$;
import apparat.log.Info$;
import apparat.log.LogLevel;
import apparat.log.LogOutput;
import apparat.log.Off$;
import apparat.log.Warning$;
import org.apache.maven.plugin.logging.Log;

public final class MavenLogAdapter
implements LogOutput {
    private final Log mavenLog;

    public static LogLevel mapLevelOf(Log log) {
        if (log.isDebugEnabled()) {
            return Debug$.MODULE$;
        }
        if (log.isInfoEnabled()) {
            return Info$.MODULE$;
        }
        if (log.isWarnEnabled()) {
            return Warning$.MODULE$;
        }
        if (log.isErrorEnabled()) {
            return Error$.MODULE$;
        }
        return Off$.MODULE$;
    }

    public MavenLogAdapter(Log log) {
        this.mavenLog = log;
    }

    public void log(LogLevel level, String message) {
        if (Debug$.MODULE$.matches(level)) {
            this.mavenLog.debug((CharSequence)message);
        } else if (Info$.MODULE$.matches(level)) {
            this.mavenLog.info((CharSequence)message);
        } else if (Warning$.MODULE$.matches(level)) {
            this.mavenLog.warn((CharSequence)message);
        } else if (Error$.MODULE$.matches(level)) {
            this.mavenLog.error((CharSequence)message);
        } else {
            this.mavenLog.error((CharSequence)("Unexpected log level: " + level));
        }
    }

    public LogLevel getLevel() {
        return MavenLogAdapter.mapLevelOf(this.mavenLog);
    }
}

