/*
 * Decompiled with CFR 0.152.
 */
package apparat.sevenzip;

import apparat.sevenzip.CRC;
import apparat.sevenzip.ICodeProgress;
import apparat.sevenzip.compression.lzma.Decoder;
import apparat.sevenzip.compression.lzma.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LzmaBench {
    static final int kAdditionalSize = 0x200000;
    static final int kCompressedAdditionalSize = 1024;
    static final int kSubBits = 8;

    static int GetLogSize(int size) {
        for (int i = 8; i < 32; ++i) {
            for (int j = 0; j < 256; ++j) {
                if (size > (1 << i) + (j << i - 8)) continue;
                return (i << 8) + j;
            }
        }
        return 8192;
    }

    static long MyMultDiv64(long value, long elapsedTime) {
        long freq = 1000L;
        long elTime = elapsedTime;
        while (freq > 1000000L) {
            freq >>>= 1;
            elTime >>>= 1;
        }
        if (elTime == 0L) {
            elTime = 1L;
        }
        return value * freq / elTime;
    }

    static long GetCompressRating(int dictionarySize, long elapsedTime, long size) {
        long t = LzmaBench.GetLogSize(dictionarySize) - 4608;
        long numCommandsForOne = 1060L + (t * t * 10L >> 16);
        long numCommands = size * numCommandsForOne;
        return LzmaBench.MyMultDiv64(numCommands, elapsedTime);
    }

    static long GetDecompressRating(long elapsedTime, long outSize, long inSize) {
        long numCommands = inSize * 220L + outSize * 20L;
        return LzmaBench.MyMultDiv64(numCommands, elapsedTime);
    }

    static long GetTotalRating(int dictionarySize, long elapsedTimeEn, long sizeEn, long elapsedTimeDe, long inSizeDe, long outSizeDe) {
        return (LzmaBench.GetCompressRating(dictionarySize, elapsedTimeEn, sizeEn) + LzmaBench.GetDecompressRating(elapsedTimeDe, inSizeDe, outSizeDe)) / 2L;
    }

    static void PrintValue(long v) {
        String s = "";
        s = s + v;
        int i = 0;
        while (i + s.length() < 6) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(s);
    }

    static void PrintRating(long rating) {
        LzmaBench.PrintValue(rating / 1000000L);
        System.out.print(" MIPS");
    }

    static void PrintResults(int dictionarySize, long elapsedTime, long size, boolean decompressMode, long secondSize) {
        long speed = LzmaBench.MyMultDiv64(size, elapsedTime);
        LzmaBench.PrintValue(speed / 1024L);
        System.out.print(" KB/s  ");
        long rating = decompressMode ? LzmaBench.GetDecompressRating(elapsedTime, size, secondSize) : LzmaBench.GetCompressRating(dictionarySize, elapsedTime, size);
        LzmaBench.PrintRating(rating);
    }

    public static int LzmaBenchmark(int numIterations, int dictionarySize) throws Exception {
        if (numIterations <= 0) {
            return 0;
        }
        if (dictionarySize < 262144) {
            System.out.println("\nError: dictionary size for benchmark must be >= 18 (256 KB)");
            return 1;
        }
        System.out.print("\n       Compressing                Decompressing\n\n");
        Encoder encoder = new Encoder();
        Decoder decoder = new Decoder();
        if (!encoder.setDictionarySize(dictionarySize)) {
            throw new Exception("Incorrect dictionary size");
        }
        int kBufferSize = dictionarySize + 0x200000;
        int kCompressedBufferSize = kBufferSize / 2 + 1024;
        ByteArrayOutputStream propStream = new ByteArrayOutputStream();
        encoder.writeCoderProperties(propStream);
        byte[] propArray = propStream.toByteArray();
        decoder.SetDecoderProperties(propArray);
        CBenchRandomGenerator rg = new CBenchRandomGenerator();
        rg.Set(kBufferSize);
        rg.Generate();
        CRC crc = new CRC();
        crc.Init();
        crc.Update(rg.Buffer, 0, rg.BufferSize);
        CProgressInfo progressInfo = new CProgressInfo();
        progressInfo.ApprovedStart = dictionarySize;
        long totalBenchSize = 0L;
        long totalEncodeTime = 0L;
        long totalDecodeTime = 0L;
        long totalCompressedSize = 0L;
        MyInputStream inStream = new MyInputStream(rg.Buffer, rg.BufferSize);
        byte[] compressedBuffer = new byte[kCompressedBufferSize];
        MyOutputStream compressedStream = new MyOutputStream(compressedBuffer);
        CrcOutStream crcOutStream = new CrcOutStream();
        MyInputStream inputCompressedStream = null;
        int compressedSize = 0;
        for (int i = 0; i < numIterations; ++i) {
            progressInfo.Init();
            inStream.reset();
            compressedStream.reset();
            encoder.code(inStream, compressedStream, -1L, -1L, progressInfo);
            long encodeTime = System.currentTimeMillis() - progressInfo.Time;
            if (i == 0) {
                compressedSize = compressedStream.size();
                inputCompressedStream = new MyInputStream(compressedBuffer, compressedSize);
            } else if (compressedSize != compressedStream.size()) {
                throw new Exception("Encoding error");
            }
            if (progressInfo.InSize == 0L) {
                throw new Exception("Internal ERROR 1282");
            }
            long decodeTime = 0L;
            for (int j = 0; j < 2; ++j) {
                inputCompressedStream.reset();
                crcOutStream.Init();
                long outSize = kBufferSize;
                long startTime = System.currentTimeMillis();
                if (!decoder.Code(inputCompressedStream, crcOutStream, outSize)) {
                    throw new Exception("Decoding Error");
                }
                decodeTime = System.currentTimeMillis() - startTime;
                if (crcOutStream.GetDigest() == crc.GetDigest()) continue;
                throw new Exception("CRC Error");
            }
            long benchSize = (long)kBufferSize - progressInfo.InSize;
            LzmaBench.PrintResults(dictionarySize, encodeTime, benchSize, false, 0L);
            System.out.print("     ");
            LzmaBench.PrintResults(dictionarySize, decodeTime, kBufferSize, true, compressedSize);
            System.out.println();
            totalBenchSize += benchSize;
            totalEncodeTime += encodeTime;
            totalDecodeTime += decodeTime;
            totalCompressedSize += (long)compressedSize;
        }
        System.out.println("---------------------------------------------------");
        LzmaBench.PrintResults(dictionarySize, totalEncodeTime, totalBenchSize, false, 0L);
        System.out.print("     ");
        LzmaBench.PrintResults(dictionarySize, totalDecodeTime, (long)kBufferSize * (long)numIterations, true, totalCompressedSize);
        System.out.println("    Average");
        return 0;
    }

    static class CProgressInfo
    implements ICodeProgress {
        public long ApprovedStart;
        public long InSize;
        public long Time;

        CProgressInfo() {
        }

        public void Init() {
            this.InSize = 0L;
        }

        @Override
        public void SetProgress(long inSize, long outSize) {
            if (inSize >= this.ApprovedStart && this.InSize == 0L) {
                this.Time = System.currentTimeMillis();
                this.InSize = inSize;
            }
        }
    }

    static class MyInputStream
    extends InputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyInputStream(byte[] buffer, int size) {
            this._buffer = buffer;
            this._size = size;
        }

        @Override
        public void reset() {
            this._pos = 0;
        }

        @Override
        public int read() {
            if (this._pos >= this._size) {
                return -1;
            }
            return this._buffer[this._pos++] & 0xFF;
        }
    }

    static class MyOutputStream
    extends OutputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyOutputStream(byte[] buffer) {
            this._buffer = buffer;
            this._size = this._buffer.length;
        }

        public void reset() {
            this._pos = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this._pos >= this._size) {
                throw new IOException("Error");
            }
            this._buffer[this._pos++] = (byte)b;
        }

        public int size() {
            return this._pos;
        }
    }

    static class CrcOutStream
    extends OutputStream {
        public CRC CRC = new CRC();

        CrcOutStream() {
        }

        public void Init() {
            this.CRC.Init();
        }

        public int GetDigest() {
            return this.CRC.GetDigest();
        }

        @Override
        public void write(byte[] b) {
            this.CRC.Update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.CRC.Update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.CRC.UpdateByte(b);
        }
    }

    static class CBenchRandomGenerator {
        CBitRandomGenerator RG = new CBitRandomGenerator();
        int Pos;
        int Rep0;
        public int BufferSize;
        public byte[] Buffer = null;

        public void Set(int bufferSize) {
            this.Buffer = new byte[bufferSize];
            this.Pos = 0;
            this.BufferSize = bufferSize;
        }

        int GetRndBit() {
            return this.RG.GetRnd(1);
        }

        int GetLogRandBits(int numBits) {
            int len = this.RG.GetRnd(numBits);
            return this.RG.GetRnd(len);
        }

        int GetOffset() {
            if (this.GetRndBit() == 0) {
                return this.GetLogRandBits(4);
            }
            return this.GetLogRandBits(4) << 10 | this.RG.GetRnd(10);
        }

        int GetLen1() {
            return this.RG.GetRnd(1 + this.RG.GetRnd(2));
        }

        int GetLen2() {
            return this.RG.GetRnd(2 + this.RG.GetRnd(2));
        }

        public void Generate() {
            this.RG.Init();
            this.Rep0 = 1;
            while (this.Pos < this.BufferSize) {
                int len;
                if (this.GetRndBit() == 0 || this.Pos < 1) {
                    this.Buffer[this.Pos++] = (byte)this.RG.GetRnd(8);
                    continue;
                }
                if (this.RG.GetRnd(3) == 0) {
                    len = 1 + this.GetLen1();
                } else {
                    do {
                        this.Rep0 = this.GetOffset();
                    } while (this.Rep0 >= this.Pos);
                    ++this.Rep0;
                    len = 2 + this.GetLen2();
                }
                int i = 0;
                while (i < len && this.Pos < this.BufferSize) {
                    this.Buffer[this.Pos] = this.Buffer[this.Pos - this.Rep0];
                    ++i;
                    ++this.Pos;
                }
            }
        }
    }

    static class CBitRandomGenerator {
        CRandomGenerator RG = new CRandomGenerator();
        int Value;
        int NumBits;

        CBitRandomGenerator() {
        }

        public void Init() {
            this.Value = 0;
            this.NumBits = 0;
        }

        public int GetRnd(int numBits) {
            if (this.NumBits > numBits) {
                int result = this.Value & (1 << numBits) - 1;
                this.Value >>>= numBits;
                this.NumBits -= numBits;
                return result;
            }
            int result = this.Value << (numBits -= this.NumBits);
            this.Value = this.RG.GetRnd();
            this.Value >>>= numBits;
            this.NumBits = 32 - numBits;
            return result |= this.Value & (1 << numBits) - 1;
        }
    }

    static class CRandomGenerator {
        int A1;
        int A2;

        public CRandomGenerator() {
            this.Init();
        }

        public void Init() {
            this.A1 = 362436069;
            this.A2 = 521288629;
        }

        public int GetRnd() {
            this.A1 = 36969 * (this.A1 & 0xFFFF) + (this.A1 >>> 16);
            this.A2 = 18000 * (this.A2 & 0xFFFF) + (this.A2 >>> 16);
            return this.A1 << 16 ^ this.A2;
        }
    }
}

