/*
 * Decompiled with CFR 0.152.
 */
package apparat.utils;

import apparat.log.Logger;
import apparat.log.SimpleLog;
import apparat.utils.Deflate$;
import apparat.utils.IO$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.Adler32;
import java.util.zip.Deflater;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class Deflate$
implements SimpleLog,
ScalaObject {
    public static final Deflate$ MODULE$;
    private boolean _7z;
    private final String _7zexe;
    private Adler32 adler32;
    private final Logger log;
    public volatile int bitmap$0;

    static {
        new Deflate$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger log() {
        if ((this.bitmap$0 & 4) != 0) return this.log;
        synchronized (this) {
            if ((this.bitmap$0 & 4) == 0) {
                this.log = SimpleLog.class.log((SimpleLog)this);
                this.bitmap$0 |= 4;
            }
            return this.log;
        }
    }

    private boolean _7z() {
        return this._7z;
    }

    private void _7z_$eq(boolean bl) {
        this._7z = bl;
    }

    private String _7zexe() {
        return this._7zexe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Adler32 adler32() {
        if ((this.bitmap$0 & 1) != 0) return this.adler32;
        synchronized (this) {
            if ((this.bitmap$0 & 1) == 0) {
                this.adler32 = new Adler32();
                this.bitmap$0 |= 1;
            }
            return this.adler32;
        }
    }

    public void compress(byte[] bytes, OutputStream output) {
        if (this._7z()) {
            this.compressUsing7z(bytes, output);
        } else {
            this.compressUsingDeflater(bytes, output);
        }
    }

    private void compressUsingDeflater(byte[] bytes, OutputStream output) {
        int numBytesCompressed;
        Deflater deflater = new Deflater(9);
        byte[] buffer = new byte[32768];
        deflater.setInput(bytes);
        deflater.finish();
        do {
            numBytesCompressed = deflater.deflate(buffer);
            output.write(buffer, 0, numBytesCompressed);
        } while (0 != numBytesCompressed);
        output.flush();
    }

    private void compressUsing7z(byte[] bytes, OutputStream output) {
        try {
            this.compress7zOnDisk(bytes, output);
        }
        catch (Throwable throwable) {
            this._7z_$eq(false);
            this.log().warning("7z failed. Fallback to normal compression.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.log().ifDebug((Function0)new anonfun.compressUsing7z.2(throwable));
            this.compressUsingDeflater(bytes, output);
        }
        catch (IOException iOException) {
            this._7z_$eq(false);
            this.log().warning("7z is not present on PATH. Fallback to normal compression.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.log().ifDebug((Function0)new anonfun.compressUsing7z.1(iOException));
            this.compressUsingDeflater(bytes, output);
        }
    }

    private void compress7zOnDisk(byte[] bytes$1, OutputStream output) {
        File gzOutput;
        File gzInput;
        block29: {
            gzInput = File.createTempFile("apparat", "input");
            gzOutput = File.createTempFile("apparat", "output");
            gzInput.deleteOnExit();
            gzOutput.deleteOnExit();
            FileOutputStream stream0 = new FileOutputStream(gzInput);
            try {
                FileOutputStream x$10 = stream0;
                x$10.write(bytes$1);
                if (stream0 == null) break block29;
            }
            catch (Throwable throwable) {
                if (stream0 != null) {
                    try {
                        try {
                            IO$.reflMethod$Method4(stream0.getClass()).invoke((Object)stream0, new Object[0]);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getCause();
                        }
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            try {
                IO$.reflMethod$Method4(stream0.getClass()).invoke((Object)stream0, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    throw invocationTargetException.getCause();
                }
                catch (Throwable throwable) {}
            }
        }
        this.log().debug("Invoking \"%s a %s -tgzip -mx9 %s\"", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this._7zexe(), gzOutput.getAbsolutePath(), gzInput.getAbsolutePath()}));
        ProcessBuilder builder = new ProcessBuilder(this._7zexe(), "a", gzOutput.getAbsolutePath(), "-tgzip", "-mx9", gzInput.getAbsolutePath());
        Process process = builder.start();
        this.log().debug("Waiting for 7z to finish.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Predef$.MODULE$.assert(0 == process.waitFor());
        File sevenZipOutput = new File(new StringBuilder().append((Object)gzOutput.getAbsolutePath()).append((Object)".gz").toString());
        FileInputStream fileInputStream = new FileInputStream(sevenZipOutput);
        sevenZipOutput.deleteOnExit();
        try {
            this.writeGZIP(bytes$1, output, IO$.MODULE$.byteArrayOf(fileInputStream));
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable3) {}
            try {
                gzInput.delete();
            }
            catch (Throwable throwable4) {}
            try {
                gzOutput.delete();
            }
            catch (Throwable throwable5) {}
            try {
                sevenZipOutput.delete();
            }
            catch (Throwable throwable6) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (Throwable throwable) {}
        try {
            gzInput.delete();
        }
        catch (Throwable throwable) {}
        try {
            gzOutput.delete();
        }
        catch (Throwable throwable) {}
        try {
            sevenZipOutput.delete();
        }
        catch (Throwable throwable) {}
    }

    private void compress7zInSTDIO(byte[] bytes, OutputStream output) {
        this.log().debug("Invoking \"%s a apparat -tgzip -mx9 -siswf -so\"", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this._7zexe()}));
        ProcessBuilder builder = new ProcessBuilder(this._7zexe(), "a", "apparat", "-tgzip", "-mx9", "-siswf", "-so");
        Process process = builder.start();
        OutputStream outputStream = process.getOutputStream();
        InputStream inputStream = process.getInputStream();
        outputStream.write(bytes);
        outputStream.close();
        byte[] buffer = new byte[32768];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.log().debug("Waiting for 7z to finish", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        while (inputStream.available() != 0) {
            int bytesRead = inputStream.read(buffer);
            byteArrayOutputStream.write(buffer, 0, bytesRead);
            Thread.sleep(8L);
        }
        inputStream.close();
        Predef$.MODULE$.assert(0 == process.waitFor());
        this.writeGZIP(bytes, output, byteArrayOutputStream.toByteArray());
    }

    private void writeGZIP(byte[] bytes, OutputStream output, byte[] gzipBuffer) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = (gzipBuffer[0] & 0xFF) == 31;
        if (!bl3) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"GZip header is corrupt.").toString());
        }
        boolean bl5 = bl2 = (gzipBuffer[1] & 0xFF) == 139;
        if (!bl2) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"GZip header is corrupt.").toString());
        }
        boolean bl6 = bl = (gzipBuffer[2] & 0xFF) == 8;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Deflate stream required.").toString());
        }
        int flags = gzipBuffer[3] & 0xFF;
        Predef$.MODULE$.assert(0 == (flags & 1), (Function0)new anonfun.writeGZIP.4());
        int bufferPos = 10;
        if (0 != (flags & 4)) {
            bufferPos = 10 + (gzipBuffer[10] & 0xFF);
        }
        if (0 != (flags & 8)) {
            while (gzipBuffer[bufferPos] != 0) {
                ++bufferPos;
            }
            ++bufferPos;
        }
        if (0 != (flags & 0x10)) {
            while (gzipBuffer[bufferPos] != 0) {
                ++bufferPos;
            }
            ++bufferPos;
        }
        if (0 != (flags & 2)) {
            bufferPos += 2;
        }
        this.adler32().reset();
        this.adler32().update(bytes);
        int checksum = (int)this.adler32().getValue();
        output.write(120);
        output.write(218);
        output.write(gzipBuffer, bufferPos, gzipBuffer.length - bufferPos - 8);
        output.write(checksum >> 24 & 0xFF);
        output.write(checksum >> 16 & 0xFF);
        output.write(checksum >> 8 & 0xFF);
        output.write(checksum & 0xFF);
        output.flush();
    }

    private Deflate$() {
        MODULE$ = this;
        SimpleLog.class.$init$((SimpleLog)this);
        String string = System.getProperty("apparat.7z.enabled", "true").toLowerCase();
        this._7z = !(string != null ? !string.equals("true") : "true" != null);
        int n = System.getProperty("os.name").indexOf("Windows");
        this._7zexe = System.getProperty("apparat.7z.path", new StringBuilder().append((Object)"7z").append((Object)(n == -1 ? "a" : ".exe")).toString());
    }
}

