/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@WebFilter(urlPatterns={"/w/decode"}, initParams={@WebInitParam(name="timeoutSec", value="10")})
public final class TimeoutFilter
implements Filter {
    private ExecutorService executorService;
    private TimeLimiter timeLimiter;
    private int timeoutSec;

    public void init(FilterConfig filterConfig) {
        this.executorService = Executors.newCachedThreadPool();
        this.timeLimiter = SimpleTimeLimiter.create((ExecutorService)this.executorService);
        this.timeoutSec = Integer.parseInt(filterConfig.getInitParameter("timeoutSec"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.timeLimiter.callWithTimeout((Callable)new /* Unavailable Anonymous Inner Class!! */, (long)this.timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.setStatus(408);
            servletResponse.getWriter().write("Request took too long");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ServletException) {
                throw (ServletException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new ServletException(e.getCause());
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }
}

