/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.integration.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.google.zxing.integration.android.IntentResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class IntentIntegrator {
    public static final int REQUEST_CODE = 195543262;
    private static final String TAG;
    public static final String DEFAULT_TITLE = "Install Barcode Scanner?";
    public static final String DEFAULT_MESSAGE = "This application requires Barcode Scanner. Would you like to install it?";
    public static final String DEFAULT_YES = "Yes";
    public static final String DEFAULT_NO = "No";
    private static final String PACKAGE = "com.google.zxing.client.android";
    public static final String PRODUCT_CODE_TYPES = "UPC_A,UPC_E,EAN_8,EAN_13";
    public static final String ONE_D_CODE_TYPES = "UPC_A,UPC_E,EAN_8,EAN_13,CODE_39,CODE_93,CODE_128";
    public static final String QR_CODE_TYPES = "QR_CODE";
    public static final String ALL_CODE_TYPES;
    public static final Method PACKAGE_SETTER;

    private IntentIntegrator() {
    }

    public static AlertDialog initiateScan(Activity activity) {
        return IntentIntegrator.initiateScan(activity, DEFAULT_TITLE, DEFAULT_MESSAGE, DEFAULT_YES, DEFAULT_NO);
    }

    public static AlertDialog initiateScan(Activity activity, int stringTitle, int stringMessage, int stringButtonYes, int stringButtonNo) {
        return IntentIntegrator.initiateScan(activity, activity.getString(stringTitle), activity.getString(stringMessage), activity.getString(stringButtonYes), activity.getString(stringButtonNo));
    }

    public static AlertDialog initiateScan(Activity activity, CharSequence stringTitle, CharSequence stringMessage, CharSequence stringButtonYes, CharSequence stringButtonNo) {
        return IntentIntegrator.initiateScan(activity, stringTitle, stringMessage, stringButtonYes, stringButtonNo, ALL_CODE_TYPES);
    }

    public static AlertDialog initiateScan(Activity activity, CharSequence stringTitle, CharSequence stringMessage, CharSequence stringButtonYes, CharSequence stringButtonNo, CharSequence stringDesiredBarcodeFormats) {
        Intent intentScan = new Intent("com.google.zxing.client.android.SCAN");
        IntentIntegrator.setPackage(intentScan);
        intentScan.addCategory("android.intent.category.DEFAULT");
        if (stringDesiredBarcodeFormats != null) {
            intentScan.putExtra("SCAN_FORMATS", stringDesiredBarcodeFormats);
        }
        try {
            activity.startActivityForResult(intentScan, 195543262);
            return null;
        }
        catch (ActivityNotFoundException e) {
            return IntentIntegrator.showDownloadDialog(activity, stringTitle, stringMessage, stringButtonYes, stringButtonNo);
        }
    }

    private static AlertDialog showDownloadDialog(final Activity activity, CharSequence stringTitle, CharSequence stringMessage, CharSequence stringButtonYes, CharSequence stringButtonNo) {
        AlertDialog.Builder downloadDialog = new AlertDialog.Builder((Context)activity);
        downloadDialog.setTitle(stringTitle);
        downloadDialog.setMessage(stringMessage);
        downloadDialog.setPositiveButton(stringButtonYes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Uri uri = Uri.parse((String)"market://search?q=pname:com.google.zxing.client.android");
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                activity.startActivity(intent);
            }
        });
        downloadDialog.setNegativeButton(stringButtonNo, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        return downloadDialog.show();
    }

    public static IntentResult parseActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 195543262) {
            if (resultCode == -1) {
                String contents = intent.getStringExtra("SCAN_RESULT");
                String formatName = intent.getStringExtra("SCAN_RESULT_FORMAT");
                return new IntentResult(contents, formatName);
            }
            return new IntentResult(null, null);
        }
        return null;
    }

    public static void shareText(Activity activity, CharSequence text) {
        IntentIntegrator.shareText(activity, text, DEFAULT_TITLE, DEFAULT_MESSAGE, DEFAULT_YES, DEFAULT_NO);
    }

    public static void shareText(Activity activity, CharSequence text, int stringTitle, int stringMessage, int stringButtonYes, int stringButtonNo) {
        IntentIntegrator.shareText(activity, text, activity.getString(stringTitle), activity.getString(stringMessage), activity.getString(stringButtonYes), activity.getString(stringButtonNo));
    }

    public static void shareText(Activity activity, CharSequence text, CharSequence stringTitle, CharSequence stringMessage, CharSequence stringButtonYes, CharSequence stringButtonNo) {
        Intent intent = new Intent();
        intent.setAction("com.google.zxing.client.android.ENCODE");
        IntentIntegrator.setPackage(intent);
        intent.putExtra("ENCODE_TYPE", "TEXT_TYPE");
        intent.putExtra("ENCODE_DATA", text);
        try {
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            IntentIntegrator.showDownloadDialog(activity, stringTitle, stringMessage, stringButtonYes, stringButtonNo);
        }
    }

    private static void setPackage(Intent intent) {
        if (PACKAGE_SETTER != null) {
            try {
                PACKAGE_SETTER.invoke((Object)intent, PACKAGE);
            }
            catch (InvocationTargetException ite) {
                Log.w((String)TAG, (Throwable)ite.getTargetException());
            }
            catch (IllegalAccessException iae) {
                Log.w((String)TAG, (Throwable)iae);
            }
        }
    }

    static {
        Method temp;
        TAG = IntentIntegrator.class.getSimpleName();
        ALL_CODE_TYPES = null;
        try {
            temp = Intent.class.getMethod("setPackage", String.class);
        }
        catch (NoSuchMethodException nsme) {
            temp = null;
        }
        PACKAGE_SETTER = temp;
    }
}

