/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonLogRecordServerUtil {
    public static LogRecord logRecordFromJson(String jsonString) throws JSONException {
        JSONObject lro = new JSONObject(jsonString);
        String level = lro.getString("level");
        String loggerName = lro.getString("loggerName");
        String msg = lro.getString("msg");
        long timestamp = Long.parseLong(lro.getString("timestamp"));
        Throwable thrown = JsonLogRecordThrowable.fromJsonString(lro.getString("thrown"));
        LogRecord lr = new LogRecord(Level.parse(level), msg);
        lr.setLoggerName(loggerName);
        lr.setThrown(thrown);
        lr.setMillis(timestamp);
        return lr;
    }

    private static class JsonLogRecordThrowable
    extends Throwable {
        private String type;

        private static Throwable fromJsonString(String jsonString) throws JSONException {
            if (jsonString.equals("{}")) {
                return null;
            }
            return new JsonLogRecordThrowable(new JSONObject(jsonString));
        }

        public JsonLogRecordThrowable(JSONObject t) throws JSONException {
            super(t.getString("message"));
            this.type = t.getString("type");
            this.setStackTrace(this.stackTraceFromJson(t.optJSONArray("stackTrace")));
            this.initCause(JsonLogRecordThrowable.fromJsonString(t.getString("cause")));
        }

        private StackTraceElement[] stackTraceFromJson(JSONArray st) throws JSONException {
            if (st == null || st.length() <= 0) {
                return new StackTraceElement[0];
            }
            StackTraceElement[] stackTrace = new StackTraceElement[st.length()];
            for (int i = 0; i < st.length(); ++i) {
                stackTrace[i] = this.stackTraceElementFromJson(st.getString(i));
            }
            return stackTrace;
        }

        private StackTraceElement stackTraceElementFromJson(String jsonString) throws JSONException {
            JSONObject ste = new JSONObject(jsonString);
            String className = ste.getString("className");
            String fileName = ste.getString("fileName");
            String methodName = ste.getString("methodName");
            int lineNumber = Integer.parseInt(ste.getString("lineNumber"));
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }

        @Override
        public String toString() {
            return this.getMessage() != null ? this.type + ": " + this.getMessage() : this.type;
        }
    }
}

