/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.Q;
import com.google.vr.sdk.widgets.video.deps.W;
import com.google.vr.sdk.widgets.video.deps.Y;
import com.google.vr.sdk.widgets.video.deps.ab;
import com.google.vr.sdk.widgets.video.deps.bJ;
import com.google.vr.sdk.widgets.video.deps.bK;
import com.google.vr.sdk.widgets.video.deps.bL;
import com.google.vr.sdk.widgets.video.deps.bM;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fR;
import com.google.vr.sdk.widgets.video.deps.gc;
import com.google.vr.sdk.widgets.video.deps.gp;
import com.google.vr.sdk.widgets.video.deps.gr;
import com.google.vr.sdk.widgets.video.deps.gv;
import com.google.vr.sdk.widgets.video.deps.gy;
import com.google.vr.sdk.widgets.video.deps.gz;
import com.google.vr.sdk.widgets.video.deps.k;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class gx
extends bK {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private final Context context;
    private final gy frameReleaseTimeHelper;
    private final gz.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private k[] streamFormats;
    private a codecMaxValues;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public gx(Context context, bL bL2) {
        this(context, bL2, 0L);
    }

    public gx(Context context, bL bL2, long l2) {
        this(context, bL2, l2, null, null, -1);
    }

    public gx(Context context, bL bL2, long l2, Handler handler, gz gz2, int n2) {
        this(context, bL2, l2, null, false, handler, gz2, n2);
    }

    public gx(Context context, bL bL2, long l2, Y<ab> y2, boolean bl2, Handler handler, gz gz2, int n2) {
        super(2, bL2, y2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new gy(context);
        this.eventDispatcher = new gz.a(handler, gz2);
        this.deviceNeedsAutoFrcWorkaround = gx.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(bL bL2, k k2) throws bM.b {
        int n2;
        int n3;
        bJ bJ2;
        String string = k2.h;
        if (!gc.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        W w2 = k2.k;
        if (w2 != null) {
            for (int i2 = 0; i2 < w2.a; ++i2) {
                bl2 |= w2.a((int)i2).d;
            }
        }
        if ((bJ2 = bL2.a(string, bl2)) == null) {
            return 1;
        }
        boolean bl3 = bJ2.b(k2.e);
        if (bl3 && k2.l > 0 && k2.m > 0) {
            if (gr.a >= 21) {
                bl3 = bJ2.a(k2.l, k2.m, k2.n);
            } else {
                boolean bl4 = bl3 = k2.l * k2.m <= bM.b();
                if (!bl3) {
                    n3 = k2.l;
                    n2 = k2.m;
                    String string2 = gr.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n3).append("x").append(n2).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n3 = bJ2.c ? 16 : 8;
        n2 = bJ2.d ? 32 : 0;
        int n4 = bl3 ? 4 : 3;
        return n3 | n2 | n4;
    }

    @Override
    protected void onEnabled(boolean bl2) throws e {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(k[] kArray, long l2) throws e {
        this.streamFormats = kArray;
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
        }
        super.onStreamChanged(kArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws e {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.consecutiveDroppedFrameCount = 0;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws e {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                gx.setVideoScalingMode(mediaCodec, this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws e {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                bJ bJ2 = this.getCodecInfo();
                if (bJ2 != null && this.shouldUseDummySurface(bJ2.e)) {
                    surface = this.dummySurface = gv.a(this.context, bJ2.e);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (gr.a >= 23 && mediaCodec != null && surface != null) {
                    gx.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(bJ bJ2) {
        return this.surface != null || this.shouldUseDummySurface(bJ2.e);
    }

    @Override
    protected void configureCodec(bJ bJ2, MediaCodec mediaCodec, k k2, MediaCrypto mediaCrypto) throws bM.b {
        this.codecMaxValues = this.getCodecMaxValues(bJ2, k2, this.streamFormats);
        MediaFormat mediaFormat = gx.getMediaFormat(k2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            fR.b(this.shouldUseDummySurface(bJ2.e));
            if (this.dummySurface == null) {
                this.dummySurface = gv.a(this.context, bJ2.e);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (gr.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
    }

    @Override
    protected void onInputFormatChanged(k k2) throws e {
        super.onInputFormatChanged(k2);
        this.eventDispatcher.a(k2);
        this.pendingPixelWidthHeightRatio = gx.getPixelWidthHeightRatio(k2);
        this.pendingRotationDegrees = gx.getRotationDegrees(k2);
    }

    @Override
    protected void onQueueInputBuffer(Q q2) {
        if (gr.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (gr.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        gx.setVideoScalingMode(mediaCodec, this.scalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl2, k k2, k k3) {
        return gx.areAdaptationCompatible(bl2, k2, k3) && k3.l <= this.codecMaxValues.a && k3.m <= this.codecMaxValues.b && k3.i <= this.codecMaxValues.c;
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) {
        while (this.pendingOutputStreamOffsetCount != 0 && l4 >= this.pendingOutputStreamOffsetsUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
        }
        long l5 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        long l6 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (gx.isBufferLate(l6)) {
                this.skipOutputBuffer(mediaCodec, n2, l5);
                return true;
            }
            return false;
        }
        if (!this.renderedFirstFrame) {
            if (gr.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l5);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l7 = SystemClock.elapsedRealtime() * 1000L - l3;
        l6 -= l7;
        long l8 = System.nanoTime();
        long l9 = l8 + l6 * 1000L;
        long l10 = this.frameReleaseTimeHelper.a(l4, l9);
        l6 = (l10 - l8) / 1000L;
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        if (gr.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, l10);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        return false;
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return gx.isBufferLate(l2);
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        gp.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gp.a();
        ++this.decoderCounters.e;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        gp.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gp.a();
        ++this.decoderCounters.f;
        ++this.droppedFrames;
        ++this.consecutiveDroppedFrameCount;
        this.decoderCounters.g = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.g);
        if (this.droppedFrames == this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        gp.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        gp.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        gp.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        gp.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(boolean bl2) {
        return gr.a >= 23 && !this.tunneling && (!bl2 || gv.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (gr.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat getMediaFormat(k k2, a a2, boolean bl2, int n2) {
        MediaFormat mediaFormat = k2.b();
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        if (a2.c != -1) {
            mediaFormat.setInteger("max-input-size", a2.c);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            gx.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    protected a getCodecMaxValues(bJ bJ2, k k2, k[] kArray) throws bM.b {
        int n2 = k2.l;
        int n3 = k2.m;
        int n4 = gx.getMaxInputSize(k2);
        if (kArray.length == 1) {
            return new a(n2, n3, n4);
        }
        boolean bl2 = false;
        for (k k3 : kArray) {
            if (!gx.areAdaptationCompatible(bJ2.c, k2, k3)) continue;
            bl2 |= k3.l == -1 || k3.m == -1;
            n2 = Math.max(n2, k3.l);
            n3 = Math.max(n3, k3.m);
            n4 = Math.max(n4, gx.getMaxInputSize(k3));
        }
        if (bl2) {
            int n5 = n2;
            int n6 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n6).toString());
            Point point = gx.getCodecMaxSize(bJ2, k2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, gx.getMaxInputSize(k2.h, n2, n3));
                n6 = n2;
                int n7 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n6).append("x").append(n7).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    private static Point getCodecMaxSize(bJ bJ2, k k2) throws bM.b {
        boolean bl2 = k2.m > k2.l;
        int n2 = bl2 ? k2.m : k2.l;
        int n3 = bl2 ? k2.l : k2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (gr.a >= 21) {
                Point point = bJ2.a(bl2 ? n5 : n4, bl2 ? n4 : n5);
                float f3 = k2.n;
                if (!bJ2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = gr.a(n4, 16) * 16) * (n5 = gr.a(n5, 16) * 16) > bM.b()) continue;
            return new Point(bl2 ? n5 : n4, bl2 ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(k k2) {
        if (k2.i != -1) {
            return k2.i;
        }
        return gx.getMaxInputSize(k2.h, k2.l, k2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(gr.d)) {
                    return -1;
                }
                n5 = gr.a(n2, 16) * gr.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static void setVideoScalingMode(MediaCodec mediaCodec, int n2) {
        mediaCodec.setVideoScalingMode(n2);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return gr.a <= 22 && "foster".equals(gr.b) && "NVIDIA".equals(gr.c);
    }

    private static boolean areAdaptationCompatible(boolean bl2, k k2, k k3) {
        return k2.h.equals(k3.h) && gx.getRotationDegrees(k2) == gx.getRotationDegrees(k3) && (bl2 || k2.l == k3.l && k2.m == k3.m);
    }

    private static float getPixelWidthHeightRatio(k k2) {
        return k2.p == -1.0f ? 1.0f : k2.p;
    }

    private static int getRotationDegrees(k k2) {
        return k2.o == -1 ? 0 : k2.o;
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != gx.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            gx.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

