/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.SphericalMetadataMP4;
import com.google.vr.sdk.widgets.video.SphericalMetadataParser;
import com.google.vr.sdk.widgets.video.SphericalV2MetadataParser;
import com.google.vr.sdk.widgets.video.VideoTexture;
import com.google.vr.sdk.widgets.video.VrSimpleExoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoView;
import com.google.vr.sdk.widgets.video.deps.aj;
import com.google.vr.sdk.widgets.video.deps.cI;
import com.google.vr.sdk.widgets.video.deps.cZ;
import com.google.vr.sdk.widgets.video.deps.co;
import com.google.vr.sdk.widgets.video.deps.cw;
import com.google.vr.sdk.widgets.video.deps.cz;
import com.google.vr.sdk.widgets.video.deps.dC;
import com.google.vr.sdk.widgets.video.deps.dd;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.eH;
import com.google.vr.sdk.widgets.video.deps.eS;
import com.google.vr.sdk.widgets.video.deps.eV;
import com.google.vr.sdk.widgets.video.deps.eZ;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.p;
import com.google.vr.sdk.widgets.video.deps.v;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VrVideoPlayer
implements co,
cw.a {
    private static final String TAG = VrVideoPlayer.class.getSimpleName();
    private static final String EXO_USER_AGENT = "Video Player Widget";
    private static final boolean DEBUG = false;
    private final VideoTexturesListener videoTexturesListener;
    private final VideoTexture videoTexture = new VideoTexture();
    private final VrSimpleExoPlayer simpleExoPlayer;
    private final int[] textureIds = new int[1];
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private boolean isBuffering = false;
    private boolean isLooping;
    private Context context;
    private VrVideoEventListener eventListener;
    private eS.a mediaDataSourceFactory;
    private float volume = 1.0f;
    private float[] cameraRotationMatrix;
    private SphericalMetadataOuterClass.SphericalMetadata metadata;

    public VrVideoPlayer(Context context, VideoTexturesListener videoTexturesListener) {
        this.context = context;
        this.simpleExoPlayer = new VrSimpleExoPlayer(context);
        this.videoTexturesListener = videoTexturesListener;
        this.simpleExoPlayer.setProjectionListener(new ProjectionDataListener());
        this.getExoPlayer().addListener(new VideoLooperListener());
        this.getExoPlayer().setPlayWhenReady(true);
    }

    private synchronized void loadVideoIntoPlayer(Uri uri, VrVideoView.Options options) {
        if (options == null) {
            options = new VrVideoView.Options();
        } else {
            options.validate();
        }
        if (this.mediaDataSourceFactory == null) {
            this.mediaDataSourceFactory = new eZ(this.context, EXO_USER_AGENT);
        }
        cz cz2 = this.buildMediaSource(uri, options);
        this.simpleExoPlayer.prepare(cz2);
        this.videoTexture.setOnNewFrameListener(new NewFrameNotifier());
        if (this.videoTexturesListener != null) {
            this.videoTexturesListener.onVideoTexturesReady();
        }
        this.applyVolumeToPlayer();
    }

    private cz buildMediaSource(Uri uri, VrVideoView.Options options) {
        switch (options.inputFormat) {
            case 2: {
                return new dC(uri, this.mediaDataSourceFactory, this.mainHandler, this);
            }
            case 3: {
                return new cZ(uri, this.mediaDataSourceFactory, new dd.a(this.mediaDataSourceFactory), this.mainHandler, (co)this);
            }
        }
        return new cw(uri, this.mediaDataSourceFactory, new aj(), this.mainHandler, this);
    }

    public void setEventListener(VrVideoEventListener vrVideoEventListener) {
        this.eventListener = vrVideoEventListener;
    }

    public void openAsset(String string, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        this.metadata = options != null ? VrVideoPlayer.createMetadataFromOptions(options) : VrVideoPlayer.parseMetadataFromVideoInputStream(this.context.getAssets().open(string));
        String string2 = String.valueOf(string);
        Uri uri = Uri.parse((String)(string2.length() != 0 ? "file:///android_asset/".concat(string2) : new String("file:///android_asset/")));
        this.loadVideoIntoPlayer(uri, options);
    }

    public void openUri(Uri uri, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        if (options != null) {
            this.metadata = VrVideoPlayer.createMetadataFromOptions(options);
        } else {
            String string = uri.getScheme();
            if (string == null || !string.startsWith("http")) {
                this.metadata = VrVideoPlayer.parseMetadataFromVideoInputStream(new FileInputStream(uri.getPath()));
            }
        }
        this.loadVideoIntoPlayer(uri, options);
    }

    public SphericalMetadataOuterClass.SphericalMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getMetadataBytes() {
        return SphericalMetadataOuterClass.SphericalMetadata.toByteArray((MessageNano)this.metadata);
    }

    public float[] getCameraRotationMatrix() {
        return this.cameraRotationMatrix;
    }

    public synchronized int[] bindTexture() {
        if (!this.videoTexture.getIsTextureSet()) {
            this.videoTexture.init();
        }
        Surface surface = new Surface(this.videoTexture.getSurfaceTexture());
        this.simpleExoPlayer.setVideoSurface(surface);
        this.simpleExoPlayer.seekTo(this.getExoPlayer().getCurrentPosition() + 1L);
        this.textureIds[0] = this.videoTexture.getTextureId();
        return this.textureIds;
    }

    public synchronized boolean prepareFrame() {
        boolean bl2 = true;
        if (this.videoTexture.getIsTextureSet()) {
            this.videoTexture.updateTexture();
            if (this.simpleExoPlayer.getFrameRotationBuffer() != null) {
                long l2 = this.videoTexture.getTimestamp() / 1000L;
                long l3 = l2 - this.simpleExoPlayer.getPresentationStartTimeUs();
                this.cameraRotationMatrix = this.simpleExoPlayer.getFrameRotationBuffer().getTransform(l3);
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public synchronized void onViewDetach() {
        this.simpleExoPlayer.setVideoSurface(null);
        this.videoTexture.release();
    }

    public synchronized void shutdown() {
        this.getExoPlayer().stop();
        this.getExoPlayer().release();
        this.videoTexture.release();
    }

    public synchronized long getCurrentPositionMs() {
        return this.getExoPlayer().getCurrentPosition();
    }

    public f getExoPlayer() {
        return this.simpleExoPlayer;
    }

    public synchronized void setVolume(float f2) {
        this.volume = f2;
        this.applyVolumeToPlayer();
    }

    void setMediaDataSourceFactory(eS.a a2) {
        this.mediaDataSourceFactory = a2;
    }

    private synchronized void applyVolumeToPlayer() {
        this.simpleExoPlayer.setVolume(this.volume);
    }

    private static SphericalMetadataOuterClass.SphericalMetadata createMetadataFromOptions(VrVideoView.Options options) {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (options.inputType) {
            case 1: {
                sphericalMetadata.frameLayoutMode = 1;
                break;
            }
            case 2: {
                sphericalMetadata.frameLayoutMode = 2;
                break;
            }
            default: {
                int n2 = options.inputType;
                throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected options.inputType ").append(n2).toString());
            }
        }
        return sphericalMetadata;
    }

    private static SphericalMetadataOuterClass.SphericalMetadata parseMetadataFromVideoInputStream(InputStream inputStream) throws IOException {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        String string = SphericalMetadataMP4.extract(inputStream);
        sphericalMetadata = SphericalMetadataParser.parse(string);
        inputStream.close();
        return sphericalMetadata;
    }

    @Override
    public void onLoadError(IOException iOException) {
        int n2 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(58 + String.valueOf(string).length()).append(n2).append("ExtractorMediaSource.EventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadStarted(eV eV2, int n2, int n3, k k2, int n4, Object object, long l2, long l3, long l4) {
    }

    @Override
    public void onLoadError(eV eV2, int n2, int n3, k k2, int n4, Object object, long l2, long l3, long l4, long l5, long l6, IOException iOException, boolean bl2) {
        int n5 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(56 + String.valueOf(string).length()).append(n5).append("AdaptiveMediaSourceEventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadCanceled(eV eV2, int n2, int n3, k k2, int n4, Object object, long l2, long l3, long l4, long l5, long l6) {
    }

    @Override
    public void onLoadCompleted(eV eV2, int n2, int n3, k k2, int n4, Object object, long l2, long l3, long l4, long l5, long l6) {
    }

    @Override
    public void onUpstreamDiscarded(int n2, long l2, long l3) {
    }

    @Override
    public void onDownstreamFormatChanged(int n2, k k2, int n3, Object object, long l2) {
    }

    private class NewFrameNotifier
    implements VideoTexture.OnNewFrameListener,
    Runnable {
        private final Handler mainHandler = new Handler(Looper.getMainLooper());

        private NewFrameNotifier() {
        }

        @Override
        public void onNewFrame() {
            this.mainHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onNewFrame();
            }
        }
    }

    private class ProjectionDataListener
    implements SphericalV2ProjectionDataListener {
        private ProjectionDataListener() {
        }

        @Override
        public void onProjectionDataChanged(int n2, byte[] byArray) {
            VrVideoPlayer.this.metadata = SphericalV2MetadataParser.parse(n2, byArray);
            if (VrVideoPlayer.this.videoTexturesListener != null) {
                VrVideoPlayer.this.videoTexturesListener.onVideoTexturesReady();
            }
        }
    }

    private class VideoLooperListener
    implements f.a {
        private VideoLooperListener() {
        }

        @Override
        public void onTracksChanged(cI cI2, eH eH2) {
        }

        @Override
        public void onPositionDiscontinuity() {
        }

        @Override
        public void onPlaybackParametersChanged(p p2) {
        }

        @Override
        public void onRepeatModeChanged(int n2) {
        }

        @Override
        public void onTimelineChanged(v v2, Object object) {
        }

        @Override
        public void onLoadingChanged(boolean bl2) {
        }

        @Override
        public void onPlayerError(e e2) {
            int n2 = this.hashCode();
            Log.e((String)TAG, (String)new StringBuilder(25).append(n2).append(".onPlayerError").toString(), (Throwable)e2);
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onLoadError(e2.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerStateChanged(boolean bl2, int n2) {
            if (n2 == 2) {
                VrVideoPlayer.this.isBuffering = true;
            } else if (n2 == 3) {
                if (VrVideoPlayer.this.isBuffering && VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.isBuffering = false;
                    VrVideoPlayer.this.eventListener.onLoadSuccess();
                }
            } else if (bl2 && n2 == 4) {
                if (VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.eventListener.onCompletion();
                }
                if (VrVideoPlayer.this.isLooping) {
                    VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
                    synchronized (vrVideoPlayer) {
                        VrVideoPlayer.this.getExoPlayer().seekTo(0L);
                    }
                }
            }
        }
    }

    static interface VideoTexturesListener {
        public void onVideoTexturesReady();
    }
}

