/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import android.os.SystemClock;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.W;
import com.google.vr.sdk.widgets.video.deps.Z;
import com.google.vr.sdk.widgets.video.deps.bL;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.gn;
import com.google.vr.sdk.widgets.video.deps.gp;
import com.google.vr.sdk.widgets.video.deps.k;
import java.nio.ByteBuffer;

public class SphericalV2MediaCodecVideoRenderer
extends gn {
    private static final int MAX_DROPPED_FRAME_COUNT_TO_NOTIFY = 1;
    private static final String TAG = SphericalV2MediaCodecVideoRenderer.class.getSimpleName();
    private long presentationStartTimeUs = 0L;
    private SphericalV2ProjectionDataListener projectionListener;

    public SphericalV2MediaCodecVideoRenderer(Context context, Handler handler, W<Z> w2, gp gp2, long l2) {
        super(context, bL.a, l2, w2, false, handler, gp2, 1);
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.projectionListener = sphericalV2ProjectionDataListener;
    }

    public long getPresentationStartTimeUs() {
        return this.presentationStartTimeUs;
    }

    @Override
    protected void onInputFormatChanged(k k2) throws e {
        super.onInputFormatChanged(k2);
        if (k2 != null && k2.q != -1 && k2.r != null && this.projectionListener != null) {
            this.projectionListener.onProjectionDataChanged(k2.q, k2.r);
        }
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) {
        long l5 = SystemClock.elapsedRealtime() * 1000L - l3;
        long l6 = l4 - l2 - l5;
        long l7 = System.nanoTime();
        long l8 = l7 + l6 * 1000L;
        this.presentationStartTimeUs = l8 / 1000L - l4;
        return super.processOutputBuffer(l2, l3, mediaCodec, byteBuffer, n2, n3, l4, bl2);
    }
}

