/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.util.Log;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.sdk.widgets.video.deps.O;
import com.google.vr.sdk.widgets.video.deps.a;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fW;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.l;
import java.io.IOException;

public final class CameraMotionMetadataRendererV2
extends a {
    private static final String TAG = "CameraMotionMetadataRenderer";
    private final l formatHolder = new l();
    private final O buffer = new O(1);
    private volatile FrameRotationBuffer frameRotationBuffer;
    private boolean inputStreamEnded = false;
    private boolean hasSample = false;

    public CameraMotionMetadataRendererV2() {
        super(4);
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.frameRotationBuffer;
    }

    @Override
    protected void onDisabled() {
        this.frameRotationBuffer = null;
    }

    @Override
    public int supportsFormat(k k2) {
        return k2.h.equals("application/x-camera-motion") ? 3 : 0;
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) {
        this.hasSample = false;
        this.inputStreamEnded = false;
    }

    @Override
    public void render(long l2, long l3) throws e {
        if (this.frameRotationBuffer == null) {
            this.frameRotationBuffer = new FrameRotationBuffer();
        }
        if (!this.inputStreamEnded && !this.hasSample) {
            this.buffer.a();
            int n2 = this.readSource(this.formatHolder, this.buffer, false);
            if (n2 == -4) {
                if (this.buffer.c()) {
                    this.inputStreamEnded = true;
                    Log.d((String)TAG, (String)"stream ended");
                } else {
                    this.hasSample = true;
                }
            }
        }
        if (this.hasSample && this.buffer.f <= l2 + 100000L) {
            try {
                this.buffer.h();
                this.frameRotationBuffer.setRotation(this.buffer.f, CameraMotionMetadataRendererV2.parseMetadata(this.buffer.e.array(), this.buffer.e.limit()));
            }
            catch (IOException iOException) {
                throw e.a(iOException, this.getIndex());
            }
            this.hasSample = false;
        }
    }

    @Override
    public boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private static float[] parseMetadata(byte[] byArray, int n2) throws IOException {
        fW fW2 = new fW(byArray, n2);
        float[] fArray = new float[3];
        fW2.d(4);
        fArray[0] = Float.intBitsToFloat(fW2.s());
        fArray[1] = Float.intBitsToFloat(fW2.s());
        fArray[2] = Float.intBitsToFloat(fW2.s());
        return fArray;
    }
}

