/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.vr.libraries.video.ProjectionScene;
import com.google.vr.sdk.widgets.video.deps.fR;
import com.google.vr.sdk.widgets.video.deps.fS;
import com.google.vr.sdk.widgets.video.deps.gd;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ProjectionMeshDecoderV2 {
    private static final int TYPE_YTMP = gd.g("ytmp");
    private static final int TYPE_MSHP = gd.g("mshp");
    private static final int TYPE_RAW = gd.g("raw ");
    private static final int TYPE_DFL8 = gd.g("dfl8");
    private static final int TYPE_MESH = gd.g("mesh");
    private static final int TYPE_PROJ = gd.g("proj");
    private static final int MAX_MESH_COUNT = 2;
    private static final int MAX_COORDINATE_COUNT = 10000;
    private static final int MAX_VERTEX_COUNT = 32000;
    private static final int MAX_TRIANGLE_INDICES = 128000;
    private static final int INITIAL_DECOMPRESS_SIZE = 100000;
    private List<ProjectionScene> sceneList = new ArrayList<ProjectionScene>();
    private boolean error;
    private ProjectionScene scene;
    private int meshCount;
    private boolean ytmpParsed;

    public ProjectionMeshDecoderV2() {
    }

    public ProjectionScene decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        this.error = false;
        this.ytmpParsed = false;
        this.scene = null;
        fS fS2 = new fS(byArray);
        if (this.isProj(fS2)) {
            return this.parseProj(fS2);
        }
        return this.parseYtmp(fS2, fS2.e());
    }

    private boolean isProj(fS fS2) {
        int n2 = fS2.d();
        fS2.c(0);
        fS2.d(4);
        int n3 = fS2.r();
        fS2.c(n2);
        return n3 == TYPE_PROJ;
    }

    private ProjectionScene parseProj(fS fS2) {
        int n2;
        fS2.d(8);
        for (int i2 = fS2.d(); i2 < fS2.e() && !this.error; i2 += n2) {
            fS2.c(i2);
            n2 = fS2.r();
            if (n2 == 0) {
                return null;
            }
            int n3 = fS2.r();
            if (n3 != TYPE_YTMP && n3 != TYPE_MSHP) continue;
            if (this.ytmpParsed) {
                return null;
            }
            ProjectionScene projectionScene = this.parseYtmp(fS2, n2 + i2);
            if (this.error) {
                return null;
            }
            if (projectionScene == null) continue;
            return projectionScene;
        }
        return null;
    }

    private boolean readFromCache(int n2) {
        for (int i2 = 0; i2 < this.sceneList.size(); ++i2) {
            if (this.sceneList.get(i2).getCrc() != n2) continue;
            this.scene = this.sceneList.get(i2);
            return true;
        }
        return false;
    }

    private ProjectionScene parseYtmp(fS fS2, int n2) {
        int n3 = fS2.h();
        fS2.d(3);
        if (n3 == 0) {
            int n4 = fS2.r();
            if (this.readFromCache(n4)) {
                return this.scene;
            }
            int n5 = fS2.r();
            if (n5 == TYPE_RAW) {
                this.parseRawYtmpData(fS2, n2, n4);
                this.ytmpParsed = true;
            } else if (n5 == TYPE_DFL8) {
                int[] nArray = new int[1];
                byte[] byArray = ProjectionMeshDecoderV2.inflate(fS2.a, fS2.d(), n2 - fS2.d(), nArray);
                if (byArray == null) {
                    return null;
                }
                fS fS3 = new fS(byArray, nArray[0]);
                this.parseRawYtmpData(fS3, nArray[0], n4);
                this.ytmpParsed = true;
            } else {
                this.error = true;
            }
            if (this.error) {
                return null;
            }
            if (this.scene.getLeftMesh() != null) {
                this.sceneList.add(this.scene);
                return this.scene;
            }
        }
        return null;
    }

    private void parseRawYtmpData(fS fS2, int n2, int n3) {
        int n4;
        this.meshCount = 0;
        this.scene = new ProjectionScene(n3);
        for (int i2 = fS2.d(); i2 < n2 && !this.error; i2 += n4) {
            fS2.c(i2);
            n4 = fS2.r();
            if (n4 == 0) {
                this.error = true;
                return;
            }
            int n5 = fS2.r();
            if (n5 != TYPE_MESH) continue;
            if (this.meshCount >= 2) {
                this.error = true;
                return;
            }
            this.parseMesh(fS2);
            ++this.meshCount;
        }
    }

    private void parseMesh(fS fS2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = fS2.r();
        if (n7 > 10000) {
            this.error = true;
            return;
        }
        float[] fArray = new float[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            fArray[n6] = fS2.A();
        }
        n6 = fS2.r();
        if (n6 > 32000) {
            this.error = true;
            return;
        }
        double d2 = Math.log(2.0);
        int n8 = (int)Math.ceil(Math.log(2.0 * (double)n7) / d2);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        fR fR2 = new fR(fS2.a);
        fR2.a(fS2.d() * 8);
        float[] fArray2 = new float[n6 * 3];
        float[] fArray3 = new float[n6 * 2];
        for (n5 = 0; n5 < n6; ++n5) {
            if (ProjectionMeshDecoderV2.isVertexInvalid(n9 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n8)), n10 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n8)), n11 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n8)), n12 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n8)), n13 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n8)), n7)) {
                this.error = true;
                return;
            }
            n4 = n5 * 3;
            fArray2[n4 + 0] = fArray[n9];
            fArray2[n4 + 1] = fArray[n10];
            fArray2[n4 + 2] = fArray[n11];
            n3 = n5 * 2;
            fArray3[n3 + 0] = fArray[n12];
            fArray3[n3 + 1] = fArray[n13];
        }
        fR2.a(fR2.b() + 7 & 0xFFFFFFF8);
        fR2.c(32);
        fR2.c(8);
        n5 = fR2.c(8);
        n4 = fR2.c(32);
        if (n4 > 128000) {
            this.error = true;
            return;
        }
        n3 = (int)Math.ceil(Math.log(2.0 * (double)n6) / d2);
        int[] nArray = new int[n4];
        int n14 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if ((n14 += ProjectionMeshDecoderV2.decodeZigZag(fR2.c(n3))) >= n6) {
                this.error = true;
                return;
            }
            nArray[n2] = n14;
        }
        n2 = 4;
        switch (n5) {
            case 1: {
                n2 = 5;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
        }
        ProjectionScene.Mesh mesh = new ProjectionScene.Mesh();
        ProjectionScene.SubMesh subMesh = new ProjectionScene.SubMesh(fArray2, fArray3, nArray, n2);
        mesh.addSubMesh(subMesh);
        if (this.meshCount == 0) {
            this.scene.setLeftMesh(mesh);
        } else if (this.meshCount == 1) {
            this.scene.setRightMesh(mesh);
        }
    }

    private static int decodeZigZag(int n2) {
        return n2 >> 1 ^ -(n2 & 1);
    }

    private static boolean isVertexInvalid(int n2, int n3, int n4, int n5, int n6, int n7) {
        return Math.max(Math.max(n2, n3), Math.max(n4, n5)) >= n7 || n6 >= n7;
    }

    static byte[] inflate(byte[] byArray, int n2, int n3, int[] nArray) {
        Inflater inflater = new Inflater(true);
        inflater.setInput(byArray, n2, n3);
        int n4 = 100000;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        boolean bl2 = false;
        try {
            do {
                n5 += inflater.inflate(byArray2, n5, n4 - n5);
                boolean bl3 = bl2 = !inflater.needsInput();
                if (!bl2) continue;
                byArray2 = ProjectionMeshDecoderV2.resizeBuffer(byArray2);
                n4 = byArray2.length;
            } while (bl2);
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        nArray[0] = n5;
        return byArray2;
    }

    private static byte[] resizeBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }
}

