/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.opengl.Matrix;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.Vector;

public class FrameRotationBuffer {
    private static final String TAG = "FrameRotationBuffer";
    private final float[] transform = new float[16];
    private final NavigableMap<Long, Vector<Float>> rotations = new TreeMap<Long, Vector<Float>>();

    public FrameRotationBuffer() {
        Matrix.setIdentityM((float[])this.transform, (int)0);
    }

    public synchronized void setRotation(long l2, float[] fArray) {
        Vector<Float> vector = new Vector<Float>();
        for (int i2 = 0; i2 < 3; ++i2) {
            vector.add(Float.valueOf(fArray[i2]));
        }
        this.rotations.put(l2, vector);
    }

    public synchronized float[] getTransform(long l2) {
        Map.Entry<Long, Vector<Float>> entry = this.rotations.floorEntry(l2);
        if (entry == null) {
            return this.transform;
        }
        this.rotations.headMap(entry.getKey()).clear();
        Vector<Float> vector = entry.getValue();
        FrameRotationBuffer.convertAngleAxisToTransformMatrix(vector.get(0).floatValue(), vector.get(1).floatValue(), vector.get(2).floatValue(), this.transform);
        return this.transform;
    }

    private static void convertAngleAxisToTransformMatrix(float f2, float f3, float f4, float[] fArray) {
        float f5 = Matrix.length((float)f2, (float)f3, (float)f4);
        if (f5 != 0.0f) {
            float f6 = (float)Math.toDegrees(f5);
            Matrix.setRotateM((float[])fArray, (int)0, (float)f6, (float)(-f2 / f5), (float)(-f3 / f5), (float)(f4 / f5));
        } else {
            Matrix.setIdentityM((float[])fArray, (int)0);
        }
    }
}

