/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.O;
import com.google.vr.sdk.widgets.video.deps.U;
import com.google.vr.sdk.widgets.video.deps.W;
import com.google.vr.sdk.widgets.video.deps.Z;
import com.google.vr.sdk.widgets.video.deps.bI;
import com.google.vr.sdk.widgets.video.deps.bJ;
import com.google.vr.sdk.widgets.video.deps.bK;
import com.google.vr.sdk.widgets.video.deps.bL;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fP;
import com.google.vr.sdk.widgets.video.deps.gb;
import com.google.vr.sdk.widgets.video.deps.gd;
import com.google.vr.sdk.widgets.video.deps.gk;
import com.google.vr.sdk.widgets.video.deps.gl;
import com.google.vr.sdk.widgets.video.deps.k;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class gj
extends bJ {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private final gk frameReleaseTimeHelper;
    private final gl.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private k[] streamFormats;
    private a codecMaxValues;
    private Surface surface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;

    public gj(Context context, bK bK2) {
        this(context, bK2, 0L);
    }

    public gj(Context context, bK bK2, long l2) {
        this(context, bK2, l2, null, null, -1);
    }

    public gj(Context context, bK bK2, long l2, Handler handler, gl gl2, int n2) {
        this(context, bK2, l2, null, false, handler, gl2, n2);
    }

    public gj(Context context, bK bK2, long l2, W<Z> w2, boolean bl2, Handler handler, gl gl2, int n2) {
        super(2, bK2, w2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.frameReleaseTimeHelper = new gk(context);
        this.eventDispatcher = new gl.a(handler, gl2);
        this.deviceNeedsAutoFrcWorkaround = gj.deviceNeedsAutoFrcWorkaround();
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(bK bK2, k k2) throws bL.b {
        int n2;
        int n3;
        bI bI2;
        String string = k2.h;
        if (!fP.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        U u2 = k2.k;
        if (u2 != null) {
            for (int i2 = 0; i2 < u2.a; ++i2) {
                bl2 |= u2.a((int)i2).c;
            }
        }
        if ((bI2 = bK2.a(string, bl2)) == null) {
            return 1;
        }
        boolean bl3 = bI2.b(k2.e);
        if (bl3 && k2.l > 0 && k2.m > 0) {
            if (gd.a >= 21) {
                bl3 = bI2.a(k2.l, k2.m, k2.n);
            } else {
                boolean bl4 = bl3 = k2.l * k2.m <= bL.b();
                if (!bl3) {
                    n3 = k2.l;
                    n2 = k2.m;
                    String string2 = gd.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n3).append("x").append(n2).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n3 = bI2.c ? 8 : 4;
        n2 = bI2.d ? 16 : 0;
        int n4 = bl3 ? 3 : 2;
        return n3 | n2 | n4;
    }

    @Override
    protected void onEnabled(boolean bl2) throws e {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(k[] kArray) throws e {
        this.streamFormats = kArray;
        super.onStreamChanged(kArray);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws e {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.consecutiveDroppedFrameCount = 0;
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if ((this.renderedFirstFrame || super.shouldInitCodec()) && super.isReady()) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.joiningDeadlineMs = -9223372036854775807L;
    }

    @Override
    protected void onStopped() {
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws e {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                gj.setVideoScalingMode(mediaCodec, this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws e {
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (gd.a >= 23 && mediaCodec != null && surface != null) {
                    gj.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null && this.surface.isValid();
    }

    @Override
    protected void configureCodec(bI bI2, MediaCodec mediaCodec, k k2, MediaCrypto mediaCrypto) throws bL.b {
        this.codecMaxValues = gj.getCodecMaxValues(bI2, k2, this.streamFormats);
        MediaFormat mediaFormat = gj.getMediaFormat(k2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (gd.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
    }

    @Override
    protected void onInputFormatChanged(k k2) throws e {
        super.onInputFormatChanged(k2);
        this.eventDispatcher.a(k2);
        this.pendingPixelWidthHeightRatio = gj.getPixelWidthHeightRatio(k2);
        this.pendingRotationDegrees = gj.getRotationDegrees(k2);
    }

    @Override
    protected void onQueueInputBuffer(O o2) {
        if (gd.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (gd.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        gj.setVideoScalingMode(mediaCodec, this.scalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl2, k k2, k k3) {
        return gj.areAdaptationCompatible(bl2, k2, k3) && k3.l <= this.codecMaxValues.a && k3.m <= this.codecMaxValues.b && k3.i <= this.codecMaxValues.c;
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) {
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2);
            return true;
        }
        if (!this.renderedFirstFrame) {
            if (gd.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l5 = SystemClock.elapsedRealtime() * 1000L - l3;
        long l6 = l4 - l2 - l5;
        long l7 = System.nanoTime();
        long l8 = l7 + l6 * 1000L;
        long l9 = this.frameReleaseTimeHelper.a(l4, l8);
        l6 = (l9 - l7) / 1000L;
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2);
            return true;
        }
        if (gd.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l9);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n2);
            return true;
        }
        return false;
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return l2 < -30000L;
    }

    private void skipOutputBuffer(MediaCodec mediaCodec, int n2) {
        gb.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gb.a();
        ++this.decoderCounters.e;
    }

    private void dropOutputBuffer(MediaCodec mediaCodec, int n2) {
        gb.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gb.a();
        ++this.decoderCounters.f;
        ++this.droppedFrames;
        ++this.consecutiveDroppedFrameCount;
        this.decoderCounters.g = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.g);
        if (this.droppedFrames == this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    private void renderOutputBuffer(MediaCodec mediaCodec, int n2) {
        this.maybeNotifyVideoSizeChanged();
        gb.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        gb.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    private void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        gb.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l2);
        gb.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (gd.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.reportedWidth != this.currentWidth || this.reportedHeight != this.currentHeight || this.reportedUnappliedRotationDegrees != this.currentUnappliedRotationDegrees || this.reportedPixelWidthHeightRatio != this.currentPixelWidthHeightRatio) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat getMediaFormat(k k2, a a2, boolean bl2, int n2) {
        MediaFormat mediaFormat = k2.b();
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        if (a2.c != -1) {
            mediaFormat.setInteger("max-input-size", a2.c);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            gj.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    private static a getCodecMaxValues(bI bI2, k k2, k[] kArray) throws bL.b {
        int n2 = k2.l;
        int n3 = k2.m;
        int n4 = gj.getMaxInputSize(k2);
        if (kArray.length == 1) {
            return new a(n2, n3, n4);
        }
        boolean bl2 = false;
        for (k k3 : kArray) {
            if (!gj.areAdaptationCompatible(bI2.c, k2, k3)) continue;
            bl2 |= k3.l == -1 || k3.m == -1;
            n2 = Math.max(n2, k3.l);
            n3 = Math.max(n3, k3.m);
            n4 = Math.max(n4, gj.getMaxInputSize(k3));
        }
        if (bl2) {
            int n5 = n2;
            int n6 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n6).toString());
            Point point = gj.getCodecMaxSize(bI2, k2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, gj.getMaxInputSize(k2.h, n2, n3));
                n6 = n2;
                int n7 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n6).append("x").append(n7).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    private static Point getCodecMaxSize(bI bI2, k k2) throws bL.b {
        boolean bl2 = k2.m > k2.l;
        int n2 = bl2 ? k2.m : k2.l;
        int n3 = bl2 ? k2.l : k2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (gd.a >= 21) {
                Point point = bI2.a(bl2 ? n5 : n4, bl2 ? n4 : n5);
                float f3 = k2.n;
                if (!bI2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = gd.a(n4, 16) * 16) * (n5 = gd.a(n5, 16) * 16) > bL.b()) continue;
            return new Point(bl2 ? n5 : n4, bl2 ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(k k2) {
        if (k2.i != -1) {
            return k2.i;
        }
        return gj.getMaxInputSize(k2.h, k2.l, k2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(gd.d)) {
                    return -1;
                }
                n5 = gd.a(n2, 16) * gd.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static void setVideoScalingMode(MediaCodec mediaCodec, int n2) {
        mediaCodec.setVideoScalingMode(n2);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return gd.a <= 22 && "foster".equals(gd.b) && "NVIDIA".equals(gd.c);
    }

    private static boolean areAdaptationCompatible(boolean bl2, k k2, k k3) {
        return k2.h.equals(k3.h) && gj.getRotationDegrees(k2) == gj.getRotationDegrees(k3) && (bl2 || k2.l == k3.l && k2.m == k3.m);
    }

    private static float getPixelWidthHeightRatio(k k2) {
        return k2.p == -1.0f ? 1.0f : k2.p;
    }

    private static int getRotationDegrees(k k2) {
        return k2.o == -1 ? 0 : k2.o;
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != gj.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            gj.this.maybeNotifyRenderedFirstFrame();
        }
    }

    private static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

