/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.a.a.d;
import com.google.a.a.d.c;
import com.google.a.a.e;
import com.google.a.a.g.a;
import com.google.a.a.g.b.g;
import com.google.a.a.g.c.g;
import com.google.a.a.g.i;
import com.google.a.a.g.l;
import com.google.a.a.g.u;
import com.google.a.a.i.h;
import com.google.a.a.j;
import com.google.a.a.j.i;
import com.google.a.a.j.p;
import com.google.a.a.s;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.SphericalMetadataMP4;
import com.google.vr.sdk.widgets.video.SphericalMetadataParser;
import com.google.vr.sdk.widgets.video.SphericalV2MetadataParser;
import com.google.vr.sdk.widgets.video.VideoTexture;
import com.google.vr.sdk.widgets.video.VrSimpleExoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoView;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VrVideoPlayer
implements a,
i.a {
    private static final String TAG = VrVideoPlayer.class.getSimpleName();
    private static final String EXO_USER_AGENT = "Video Player Widget";
    private static final boolean DEBUG = false;
    private Handler mainHandler;
    private VrSimpleExoPlayer simpleExoPlayer;
    private VideoTexture[] videoTextures = new VideoTexture[0];
    private boolean isBuffering = false;
    private boolean isLooping;
    private Context context;
    private VrVideoEventListener eventListener;
    private VideoTexturesListener videoTexturesListener;
    private i.a mediaDataSourceFactory;
    private float volume = 1.0f;
    private float[] cameraRotationMatrix;
    private SphericalMetadataOuterClass.SphericalMetadata metadata;

    public VrVideoPlayer(Context context) {
        this.context = context;
        this.init(context);
    }

    private void init(Context context) {
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.simpleExoPlayer = new VrSimpleExoPlayer(context);
        this.simpleExoPlayer.setProjectionListener(new ProjectionDataListener());
        this.getExoPlayer().addListener(new VideoLooperListener());
        this.getExoPlayer().setPlayWhenReady(true);
    }

    private void loadVideoIntoPlayer(Uri uri, VrVideoView.Options options) {
        if (options == null) {
            options = new VrVideoView.Options();
        } else {
            options.validate();
        }
        if (this.mediaDataSourceFactory == null) {
            this.mediaDataSourceFactory = new p(this.context, EXO_USER_AGENT);
        }
        l l2 = this.buildMediaSource(uri, options);
        this.simpleExoPlayer.prepare(l2);
        this.videoTextures = new VideoTexture[1];
        this.videoTextures[0] = new VideoTexture();
        this.videoTextures[0].setOnNewFrameListener(new NewFrameNotifier());
        if (this.videoTexturesListener != null) {
            this.videoTexturesListener.onVideoTexturesReady();
        }
        this.applyVolumeToPlayer();
    }

    private l buildMediaSource(Uri uri, VrVideoView.Options options) {
        switch (options.inputFormat) {
            case 2: {
                return new g(uri, this.mediaDataSourceFactory, this.mainHandler, this);
            }
            case 3: {
                return new com.google.a.a.g.b.c(uri, this.mediaDataSourceFactory, new g.a(this.mediaDataSourceFactory), this.mainHandler, (a)this);
            }
        }
        return new i(uri, this.mediaDataSourceFactory, new c(), this.mainHandler, this);
    }

    public void setEventListener(VrVideoEventListener vrVideoEventListener) {
        this.eventListener = vrVideoEventListener;
    }

    public void openAsset(String string, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        this.metadata = options != null ? VrVideoPlayer.createMetadataFromOptions(options) : VrVideoPlayer.parseMetadataFromVideoInputStream(this.context.getAssets().open(string));
        String string2 = String.valueOf(string);
        Uri uri = Uri.parse((String)(string2.length() != 0 ? "file:///android_asset/".concat(string2) : new String("file:///android_asset/")));
        this.loadVideoIntoPlayer(uri, options);
    }

    public void openUri(Uri uri, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        if (options != null) {
            this.metadata = VrVideoPlayer.createMetadataFromOptions(options);
        } else {
            String string = uri.getScheme();
            if (string == null || !string.startsWith("http")) {
                this.metadata = VrVideoPlayer.parseMetadataFromVideoInputStream(new FileInputStream(uri.getPath()));
            }
        }
        this.loadVideoIntoPlayer(uri, options);
    }

    public SphericalMetadataOuterClass.SphericalMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getMetadataBytes() {
        return SphericalMetadataOuterClass.SphericalMetadata.toByteArray((MessageNano)this.metadata);
    }

    public float[] getCameraRotationMatrix() {
        return this.cameraRotationMatrix;
    }

    public synchronized int[] bindTexture() {
        if (this.videoTextures.length == 0) {
            throw new IllegalStateException("openXXX() should be called successfully first.");
        }
        int[] nArray = new int[this.videoTextures.length];
        for (int i2 = 0; i2 < this.videoTextures.length; ++i2) {
            VideoTexture videoTexture = this.videoTextures[i2];
            if (!videoTexture.getIsTextureSet()) {
                videoTexture.init();
            }
            Surface surface = new Surface(videoTexture.getSurfaceTexture());
            this.simpleExoPlayer.setVideoSurface(surface);
            this.getExoPlayer().seekTo(this.getExoPlayer().getCurrentPosition() + 1L);
            nArray[i2] = videoTexture.getTextureId();
        }
        return nArray;
    }

    public synchronized boolean prepareFrame() {
        boolean bl = this.videoTextures.length > 0;
        for (VideoTexture videoTexture : this.videoTextures) {
            if (videoTexture.getIsTextureSet()) {
                videoTexture.updateTexture();
                if (this.simpleExoPlayer.getFrameRotationBuffer() == null) continue;
                long l2 = videoTexture.getTimestamp() / 1000L;
                long l3 = l2 - this.simpleExoPlayer.getPresentationStartTimeUs();
                this.cameraRotationMatrix = this.simpleExoPlayer.getFrameRotationBuffer().getTransform(l3);
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public synchronized void onViewDetach() {
        for (int i2 = 0; i2 < this.videoTextures.length; ++i2) {
            this.simpleExoPlayer.setVideoSurface(null);
            this.videoTextures[i2].release();
        }
    }

    public synchronized void shutdown() {
        this.getExoPlayer().stop();
        this.getExoPlayer().release();
        for (VideoTexture videoTexture : this.videoTextures) {
            videoTexture.release();
        }
    }

    public synchronized long getCurrentPositionMs() {
        return this.getExoPlayer().getCurrentPosition();
    }

    public e getExoPlayer() {
        return this.simpleExoPlayer;
    }

    public void setVideoTexturesListener(VideoTexturesListener videoTexturesListener) {
        this.videoTexturesListener = videoTexturesListener;
    }

    public synchronized void setVolume(float f2) {
        this.volume = f2;
        this.applyVolumeToPlayer();
    }

    void setMediaDataSourceFactory(i.a a2) {
        this.mediaDataSourceFactory = a2;
    }

    private synchronized void applyVolumeToPlayer() {
        this.simpleExoPlayer.setVolume(this.volume);
    }

    private static SphericalMetadataOuterClass.SphericalMetadata createMetadataFromOptions(VrVideoView.Options options) {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (options.inputType) {
            case 1: {
                sphericalMetadata.frameLayoutMode = 1;
                break;
            }
            case 2: {
                sphericalMetadata.frameLayoutMode = 2;
                break;
            }
            default: {
                int n2 = options.inputType;
                throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected options.inputType ").append(n2).toString());
            }
        }
        return sphericalMetadata;
    }

    private static SphericalMetadataOuterClass.SphericalMetadata parseMetadataFromVideoInputStream(InputStream inputStream) throws IOException {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        String string = SphericalMetadataMP4.extract(inputStream);
        sphericalMetadata = SphericalMetadataParser.parse(string);
        inputStream.close();
        return sphericalMetadata;
    }

    @Override
    public void onLoadError(IOException iOException) {
        int n2 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(58 + String.valueOf(string).length()).append(n2).append("ExtractorMediaSource.EventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadStarted(com.google.a.a.j.l l2, int n2, int n3, j j2, int n4, Object object, long l3, long l4, long l5) {
    }

    @Override
    public void onLoadError(com.google.a.a.j.l l2, int n2, int n3, j j2, int n4, Object object, long l3, long l4, long l5, long l6, long l7, IOException iOException, boolean bl) {
        int n5 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(56 + String.valueOf(string).length()).append(n5).append("AdaptiveMediaSourceEventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadCanceled(com.google.a.a.j.l l2, int n2, int n3, j j2, int n4, Object object, long l3, long l4, long l5, long l6, long l7) {
    }

    @Override
    public void onLoadCompleted(com.google.a.a.j.l l2, int n2, int n3, j j2, int n4, Object object, long l3, long l4, long l5, long l6, long l7) {
    }

    @Override
    public void onUpstreamDiscarded(int n2, long l2, long l3) {
    }

    @Override
    public void onDownstreamFormatChanged(int n2, j j2, int n3, Object object, long l2) {
    }

    private class NewFrameNotifier
    implements VideoTexture.OnNewFrameListener,
    Runnable {
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private NewFrameNotifier() {
        }

        @Override
        public void onNewFrame() {
            this.mainHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onNewFrame();
            }
        }
    }

    private class ProjectionDataListener
    implements SphericalV2ProjectionDataListener {
        private ProjectionDataListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProjectionDataChanged(int n2, byte[] byArray) {
            VrVideoPlayer.this.metadata = SphericalV2MetadataParser.parse(n2, byArray);
            VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
            synchronized (vrVideoPlayer) {
                boolean bl;
                boolean bl2 = bl = VrVideoPlayer.this.videoTextures.length > 0;
                if (bl && VrVideoPlayer.this.videoTexturesListener != null) {
                    VrVideoPlayer.this.videoTexturesListener.onVideoTexturesReady();
                }
            }
        }
    }

    private class VideoLooperListener
    implements e.a {
        private VideoLooperListener() {
        }

        @Override
        public void onTracksChanged(u u2, h h2) {
        }

        @Override
        public void onPositionDiscontinuity() {
        }

        @Override
        public void onTimelineChanged(s s2, Object object) {
        }

        @Override
        public void onLoadingChanged(boolean bl) {
        }

        @Override
        public void onPlayerError(d d2) {
            int n2 = this.hashCode();
            Log.e((String)TAG, (String)new StringBuilder(25).append(n2).append(".onPlayerError").toString(), (Throwable)d2);
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onLoadError(d2.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerStateChanged(boolean bl, int n2) {
            if (n2 == 2) {
                VrVideoPlayer.this.isBuffering = true;
            } else if (n2 == 3) {
                if (VrVideoPlayer.this.isBuffering && VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.isBuffering = false;
                    VrVideoPlayer.this.eventListener.onLoadSuccess();
                }
            } else if (bl && n2 == 4) {
                if (VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.eventListener.onCompletion();
                }
                if (VrVideoPlayer.this.isLooping) {
                    VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
                    synchronized (vrVideoPlayer) {
                        VrVideoPlayer.this.getExoPlayer().seekTo(0L);
                    }
                }
            }
        }
    }

    public static interface VideoTexturesListener {
        public void onVideoTexturesReady();
    }
}

