/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.util.Log;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SphericalMetadataParser {
    private static final String TAG = SphericalMetadataParser.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String INITIAL_HEADING = "InitialViewHeadingDegrees";
    private static final String INITIAL_PITCH = "InitialViewPitchDegrees";
    private static final String INITIAL_ROLL = "InitialViewRollDegrees";
    private static final String SPHERICAL = "Spherical";
    private static final String STITCHED = "Stitched";
    private static final String STITCHING_SOFTWARE = "StitchingSoftware";
    private static final String PROJECTION_TYPE = "ProjectionType";
    private static final String STEREO_MODE = "StereoMode";
    private static final String STEREO_MODE_MONO = "mono";
    private static final String STEREO_MODE_LEFT_RIGHT = "left-right";
    private static final String STEREO_MODE_TOP_BOTTOM = "top-bottom";

    public static SphericalMetadataOuterClass.SphericalMetadata parse(String string) {
        if (string == null) {
            return new SphericalMetadataOuterClass.SphericalMetadata();
        }
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(true);
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput((InputStream)new StringBufferInputStream(string), null);
            xmlPullParser.nextTag();
            return SphericalMetadataParser.readFeed(xmlPullParser);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.getMessage());
            return new SphericalMetadataOuterClass.SphericalMetadata();
        }
    }

    private static SphericalMetadataOuterClass.SphericalMetadata readFeed(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        while (xmlPullParser.next() != 1) {
            String string;
            if (xmlPullParser.getEventType() != 2) continue;
            int n2 = 1;
            String string2 = "";
            while (n2 > 0) {
                switch (xmlPullParser.next()) {
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n2;
                        break;
                    }
                    case 4: {
                        string2 = xmlPullParser.getText();
                    }
                }
            }
            if (string2 == null) continue;
            block15 : switch (string = xmlPullParser.getName()) {
                case "InitialViewHeadingDegrees": {
                    sphericalMetadata.initialViewHeadingDegrees = Integer.parseInt(string2);
                    break;
                }
                case "InitialViewPitchDegrees": {
                    sphericalMetadata.initialViewPitchDegrees = Integer.parseInt(string2);
                    break;
                }
                case "InitialViewRollDegrees": {
                    sphericalMetadata.initialViewRollDegrees = Integer.parseInt(string2);
                    break;
                }
                case "StereoMode": {
                    switch (string2) {
                        case "top-bottom": {
                            sphericalMetadata.frameLayoutMode = 2;
                            break block15;
                        }
                        case "left-right": {
                            Log.e((String)TAG, (String)"left-right videos are unsupported");
                        }
                    }
                    sphericalMetadata.frameLayoutMode = 1;
                    break;
                }
                case "Spherical": 
                case "Stitched": 
                case "StitchingSoftware": 
                case "ProjectionType": {
                    break;
                }
                default: {
                    String string3 = String.valueOf(string);
                    Log.w((String)TAG, (String)(string3.length() != 0 ? "Unknown name: ".concat(string3) : new String("Unknown name: ")));
                }
            }
        }
        return sphericalMetadata;
    }
}

