/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class SphericalMetadataMP4 {
    private static final String TAG = "SphericalMetadataMP4";
    private static final String[] METADATA_PATH = new String[]{"moov", "trak"};
    private static final String METADATA_ATOM = "uuid";
    private static final byte[] SPHERICAL_UUID = new byte[]{-1, -52, -126, 99, -8, 85, 74, -109, -120, 20, 88, 122, 2, 82, 31, -35};
    private static final String METADATA_ATOM_CHARSET = "UTF-8";
    private static final long MIN_ATOM_SIZE = 8L;
    private static final long ATOM_SIZE_64_BITS = 1L;

    public static String extract(InputStream inputStream) {
        if (inputStream == null) {
            Log.e((String)TAG, (String)"Failed to extract metadata string from mp4: no stream!");
            return null;
        }
        try {
            return SphericalMetadataMP4.extract(inputStream, 0, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to extract metadata string from mp4.", (Throwable)exception);
            return null;
        }
    }

    private static String extract(InputStream inputStream, int n2, long l2) throws IOException {
        if (n2 > METADATA_PATH.length) {
            throw new IllegalArgumentException("Search depth exceeds expectations.");
        }
        int n3 = 0;
        while ((long)n3 < l2 || n2 == 0) {
            Object object;
            byte[] byArray = SphericalMetadataMP4.readBytes(inputStream, 4);
            n3 += 4;
            if (byArray == null) {
                if (n2 == 0) break;
                int n4 = n3;
                throw new IOException(new StringBuilder(69).append("Unexpected end of stream.").append(n4).append(" ").append(l2).append(" ").append(n2).toString());
            }
            long l3 = SphericalMetadataMP4.bytesToInt(byArray, 4);
            if (l3 < 8L && l3 != 1L) {
                long l4 = l3;
                throw new IOException(new StringBuilder(39).append("Invalid atom size: ").append(l4).toString());
            }
            byte[] byArray2 = SphericalMetadataMP4.readBytes(inputStream, 4);
            n3 += 4;
            if (byArray2 == null) {
                throw new IOException("Unexpected end of stream.");
            }
            String string = SphericalMetadataMP4.bytesToString(byArray2, METADATA_ATOM_CHARSET);
            if (string == null || string.length() != 4) {
                throw new IOException("Invalid atom name.");
            }
            long l5 = l3 - 8L;
            if (l3 == 1L) {
                byArray = SphericalMetadataMP4.readBytes(inputStream, 8);
                n3 += 8;
                if (byArray == null) {
                    throw new IOException("Unexpected end of stream.");
                }
                l3 = SphericalMetadataMP4.bytesToInt(byArray, 8);
                l5 = l3 - 16L;
                if (l3 < 8L) {
                    long l6 = l3;
                    throw new IOException(new StringBuilder(39).append("Invalid atom size: ").append(l6).toString());
                }
            }
            if (n2 != METADATA_PATH.length && METADATA_PATH[n2].equals(string)) {
                object = SphericalMetadataMP4.extract(inputStream, n2 + 1, l3 - 8L);
                if (object != null) {
                    return object;
                }
                n3 = (int)((long)n3 + l5);
                l5 = 0L;
            } else if (n2 == METADATA_PATH.length && METADATA_ATOM.equals(string)) {
                object = SphericalMetadataMP4.readBytes(inputStream, SPHERICAL_UUID.length);
                n3 += SPHERICAL_UUID.length;
                l5 -= (long)SPHERICAL_UUID.length;
                if (object == null) {
                    throw new IOException("Failed to parse UUID.");
                }
                if (Arrays.equals(object, SPHERICAL_UUID)) {
                    byte[] byArray3 = SphericalMetadataMP4.readBytes(inputStream, (int)l5);
                    String string2 = SphericalMetadataMP4.bytesToString(byArray3, METADATA_ATOM_CHARSET);
                    if (string2 == null) {
                        throw new IOException("Error retrieving metadata xml.");
                    }
                    String string3 = String.valueOf(string2);
                    Log.i((String)TAG, (String)(string3.length() != 0 ? "Located spherical metadata:\n".concat(string3) : new String("Located spherical metadata:\n")));
                    return string2;
                }
            }
            while (l5 > 0L) {
                long l7 = inputStream.skip(l5);
                if (l7 <= 0L) continue;
                l5 -= l7;
                n3 = (int)((long)n3 + l7);
            }
        }
        return null;
    }

    private static byte[] readBytes(InputStream inputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = inputStream.read(byArray, i2, n2 - i2);
            if (n3 != -1) continue;
            return null;
        }
        return byArray;
    }

    private static long bytesToInt(byte[] byArray, int n2) {
        if (byArray == null || byArray.length != n2 || n2 > 8) {
            throw new IllegalArgumentException("Invalid byte array.");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 |= (byArray[i2] & 0xFF) << 8 * (n2 - 1 - i2);
        }
        return n3;
    }

    private static String bytesToString(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null byte array.");
        }
        try {
            return new String(byArray, string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid charset.");
        }
    }
}

