/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import java.util.ArrayList;
import java.util.List;

public class ProjectionScene {
    private int crc;
    private Mesh[] meshes;
    private int stereoMode;

    public ProjectionScene(int n2) {
        this.crc = n2;
        this.meshes = new Mesh[2];
    }

    public Mesh getLeftMesh() {
        return this.meshes[0];
    }

    public void setLeftMesh(Mesh mesh) {
        this.meshes[0] = mesh;
    }

    public Mesh getRightMesh() {
        return this.meshes[1];
    }

    public void setRightMesh(Mesh mesh) {
        this.meshes[1] = mesh;
    }

    public int getCrc() {
        return this.crc;
    }

    public int getStereoMode() {
        return this.stereoMode;
    }

    public void setStereoMode(int n2) {
        this.stereoMode = n2;
    }

    public static class Mesh {
        private List<SubMesh> subMeshes = new ArrayList<SubMesh>();

        public void addSubMesh(SubMesh subMesh) {
            this.subMeshes.add(subMesh);
        }

        public int getSubMeshCount() {
            return this.subMeshes.size();
        }

        public SubMesh getSubMesh(int n2) {
            return this.subMeshes.get(n2);
        }
    }

    public static class SubMesh {
        private int mode;
        private float[] vertices;
        private float[] textureCoords;

        public SubMesh(float[] fArray, float[] fArray2, int n2) {
            this.vertices = fArray;
            this.textureCoords = fArray2;
            this.mode = n2;
        }

        public int getMode() {
            return this.mode;
        }

        public float[] getVertices() {
            return this.vertices;
        }

        public float[] getTextureCoords() {
            return this.textureCoords;
        }
    }
}

