/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.a.a.k.A;
import com.google.a.a.k.n;
import com.google.a.a.k.o;
import com.google.vr.libraries.video.ProjectionScene;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ProjectionMeshDecoderV2 {
    private static final int TYPE_YTMP = A.g("ytmp");
    private static final int TYPE_MSHP = A.g("mshp");
    private static final int TYPE_RAW = A.g("raw ");
    private static final int TYPE_DFL8 = A.g("dfl8");
    private static final int TYPE_MESH = A.g("mesh");
    private static final int TYPE_PROJ = A.g("proj");
    private static final int MAX_MESH_COUNT = 2;
    private static final int MAX_COORDINATE_COUNT = 10000;
    private static final int MAX_VERTEX_COUNT = 32000;
    private static final int MAX_TRIANGLE_INDICES = 128000;
    private static final int INITIAL_DECOMPRESS_SIZE = 100000;
    private List<ProjectionScene> sceneList = new ArrayList<ProjectionScene>();
    private boolean error;
    private ProjectionScene scene;
    private int meshCount;
    private boolean ytmpParsed;

    public ProjectionScene decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        this.error = false;
        this.ytmpParsed = false;
        this.scene = null;
        o o2 = new o(byArray);
        if (this.isProj(o2)) {
            return this.parseProj(o2);
        }
        return this.parseYtmp(o2, o2.e());
    }

    private boolean isProj(o o2) {
        int n2 = o2.d();
        o2.c(0);
        o2.d(4);
        int n3 = o2.q();
        o2.c(n2);
        return n3 == TYPE_PROJ;
    }

    private ProjectionScene parseProj(o o2) {
        int n2;
        o2.d(8);
        for (int i2 = o2.d(); i2 < o2.e() && !this.error; i2 += n2) {
            o2.c(i2);
            n2 = o2.q();
            if (n2 == 0) {
                return null;
            }
            int n3 = o2.q();
            if (n3 != TYPE_YTMP && n3 != TYPE_MSHP) continue;
            if (this.ytmpParsed) {
                return null;
            }
            ProjectionScene projectionScene = this.parseYtmp(o2, n2 + i2);
            if (this.error) {
                return null;
            }
            if (projectionScene == null) continue;
            return projectionScene;
        }
        return null;
    }

    private boolean readFromCache(int n2) {
        for (int i2 = 0; i2 < this.sceneList.size(); ++i2) {
            if (this.sceneList.get(i2).getCrc() != n2) continue;
            this.scene = this.sceneList.get(i2);
            return true;
        }
        return false;
    }

    private ProjectionScene parseYtmp(o o2, int n2) {
        int n3 = o2.g();
        o2.d(3);
        if (n3 == 0) {
            int n4 = o2.q();
            if (this.readFromCache(n4)) {
                return this.scene;
            }
            int n5 = o2.q();
            if (n5 == TYPE_RAW) {
                this.parseRawYtmpData(o2, n2, n4);
                this.ytmpParsed = true;
            } else if (n5 == TYPE_DFL8) {
                int[] nArray = new int[1];
                byte[] byArray = ProjectionMeshDecoderV2.inflate(o2.a, o2.d(), n2 - o2.d(), nArray);
                if (byArray == null) {
                    return null;
                }
                o o3 = new o(byArray, nArray[0]);
                this.parseRawYtmpData(o3, nArray[0], n4);
                this.ytmpParsed = true;
            } else {
                this.error = true;
            }
            if (this.error) {
                return null;
            }
            if (this.scene.getLeftMesh() != null) {
                this.sceneList.add(this.scene);
                return this.scene;
            }
        }
        return null;
    }

    private void parseRawYtmpData(o o2, int n2, int n3) {
        int n4;
        this.meshCount = 0;
        this.scene = new ProjectionScene(n3);
        for (int i2 = o2.d(); i2 < n2 && !this.error; i2 += n4) {
            o2.c(i2);
            n4 = o2.q();
            if (n4 == 0) {
                this.error = true;
                return;
            }
            int n5 = o2.q();
            if (n5 != TYPE_MESH) continue;
            if (this.meshCount >= 2) {
                this.error = true;
                return;
            }
            this.parseMesh(o2);
            ++this.meshCount;
        }
    }

    private void parseMesh(o o2) {
        int n2 = o2.q();
        if (n2 > 10000) {
            this.error = true;
            return;
        }
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3++] = o2.z();
        }
        int n4 = o2.q();
        if (n4 > 32000) {
            this.error = true;
            return;
        }
        double d2 = Math.log(2.0);
        int n5 = (int)Math.ceil(Math.log(2.0 * (double)n2) / d2);
        n3 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        n n11 = new n(o2.a);
        n11.a(o2.d() * 8);
        float[] fArray2 = new float[n4 * 5];
        int n12 = 0;
        while (n3++ < n4) {
            if (ProjectionMeshDecoderV2.isVertexInvalid(n6 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n5)), n7 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n5)), n8 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n5)), n9 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n5)), n10 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n5)), n2)) {
                this.error = true;
                return;
            }
            fArray2[n12++] = fArray[n6];
            fArray2[n12++] = fArray[n7];
            fArray2[n12++] = fArray[n8];
            fArray2[n12++] = fArray[n9];
            fArray2[n12++] = fArray[n10];
        }
        n11.a(n11.b() + 7 & 0xFFFFFFF8);
        n11.c(32);
        n11.c(8);
        int n13 = n11.c(8);
        int n14 = n11.c(32);
        if (n14 > 128000) {
            this.error = true;
            return;
        }
        int n15 = (int)Math.ceil(Math.log(2.0 * (double)n4) / d2);
        int n16 = 0;
        float[] fArray3 = new float[n14 * 3];
        float[] fArray4 = new float[n14 * 2];
        for (n3 = 0; n3 < n14; ++n3) {
            if ((n16 += ProjectionMeshDecoderV2.decodeZigZag(n11.c(n15))) >= n4) {
                this.error = true;
                return;
            }
            fArray3[n3 * 3] = fArray2[n16 * 5];
            fArray3[n3 * 3 + 1] = fArray2[n16 * 5 + 1];
            fArray3[n3 * 3 + 2] = fArray2[n16 * 5 + 2];
            fArray4[n3 * 2] = fArray2[n16 * 5 + 3];
            fArray4[n3 * 2 + 1] = fArray2[n16 * 5 + 4];
        }
        int n17 = 4;
        switch (n13) {
            case 1: {
                n17 = 5;
                break;
            }
            case 2: {
                n17 = 6;
                break;
            }
        }
        ProjectionScene.Mesh mesh = new ProjectionScene.Mesh();
        ProjectionScene.SubMesh subMesh = new ProjectionScene.SubMesh(fArray3, fArray4, n17);
        mesh.addSubMesh(subMesh);
        if (this.meshCount == 0) {
            this.scene.setLeftMesh(mesh);
        } else if (this.meshCount == 1) {
            this.scene.setRightMesh(mesh);
        }
    }

    private static int decodeZigZag(int n2) {
        return n2 >> 1 ^ -(n2 & 1);
    }

    private static boolean isVertexInvalid(int n2, int n3, int n4, int n5, int n6, int n7) {
        return Math.max(Math.max(n2, n3), Math.max(n4, n5)) >= n7 || n6 >= n7;
    }

    static byte[] inflate(byte[] byArray, int n2, int n3, int[] nArray) {
        Inflater inflater = new Inflater(true);
        inflater.setInput(byArray, n2, n3);
        int n4 = 100000;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        boolean bl = false;
        try {
            do {
                n5 += inflater.inflate(byArray2, n5, n4 - n5);
                boolean bl2 = bl = !inflater.needsInput();
                if (!bl) continue;
                byArray2 = ProjectionMeshDecoderV2.resizeBuffer(byArray2);
                n4 = byArray2.length;
            } while (bl);
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        nArray[0] = n5;
        return byArray2;
    }

    private static byte[] resizeBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }
}

