/*
 * Decompiled with CFR 0.152.
 */
package com.google.a.a.l;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.a.a.c.h;
import com.google.a.a.d;
import com.google.a.a.e.d;
import com.google.a.a.j;
import com.google.a.a.k.A;
import com.google.a.a.k.l;
import com.google.a.a.k.y;
import com.google.a.a.l.e;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class c
extends com.google.a.a.e.b {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private final com.google.a.a.l.d frameReleaseTimeHelper;
    private final e.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private j[] streamFormats;
    private a codecMaxValues;
    private Surface surface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int lastReportedWidth;
    private int lastReportedHeight;
    private int lastReportedUnappliedRotationDegrees;
    private float lastReportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;

    public c(Context context, com.google.a.a.e.c c2) {
        this(context, c2, 0L);
    }

    public c(Context context, com.google.a.a.e.c c2, long l2) {
        this(context, c2, l2, null, null, -1);
    }

    public c(Context context, com.google.a.a.e.c c2, long l2, Handler handler, e e2, int n2) {
        this(context, c2, l2, null, false, handler, e2, n2);
    }

    public c(Context context, com.google.a.a.e.c c2, long l2, com.google.a.a.c.e<h> e2, boolean bl, Handler handler, e e3, int n2) {
        super(2, c2, e2, bl);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.frameReleaseTimeHelper = new com.google.a.a.l.d(context);
        this.eventDispatcher = new e.a(handler, e3);
        this.deviceNeedsAutoFrcWorkaround = c.deviceNeedsAutoFrcWorkaround();
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearLastReportedVideoSize();
    }

    @Override
    protected int supportsFormat(com.google.a.a.e.c c2, j j2) throws d.b {
        int n2;
        int n3;
        com.google.a.a.e.a a2;
        String string = j2.h;
        if (!l.b(string)) {
            return 0;
        }
        boolean bl = false;
        com.google.a.a.c.c c3 = j2.k;
        if (c3 != null) {
            for (int i2 = 0; i2 < c3.a; ++i2) {
                bl |= c3.a((int)i2).c;
            }
        }
        if ((a2 = c2.a(string, bl)) == null) {
            return 1;
        }
        boolean bl2 = a2.b(j2.e);
        if (bl2 && j2.l > 0 && j2.m > 0) {
            if (A.a >= 21) {
                bl2 = a2.a(j2.l, j2.m, j2.n);
            } else {
                boolean bl3 = bl2 = j2.l * j2.m <= com.google.a.a.e.d.b();
                if (!bl2) {
                    n3 = j2.l;
                    n2 = j2.m;
                    String string2 = A.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n3).append("x").append(n2).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n3 = a2.c ? 8 : 4;
        n2 = a2.d ? 16 : 0;
        int n4 = bl2 ? 3 : 2;
        return n3 | n2 | n4;
    }

    @Override
    protected void onEnabled(boolean bl) throws d {
        super.onEnabled(bl);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(j[] jArray) throws d {
        this.streamFormats = jArray;
        super.onStreamChanged(jArray);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl) throws d {
        super.onPositionReset(l2, bl);
        this.clearRenderedFirstFrame();
        this.consecutiveDroppedFrameCount = 0;
        this.joiningDeadlineMs = bl && this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    @Override
    public boolean isReady() {
        if ((this.renderedFirstFrame || super.shouldInitCodec()) && super.isReady()) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.clearLastReportedVideoSize();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws d {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 5) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                c.setVideoScalingMode(mediaCodec, this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws d {
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                this.releaseCodec();
                this.maybeInitCodec();
            }
        }
        this.clearRenderedFirstFrame();
        this.clearLastReportedVideoSize();
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null && this.surface.isValid();
    }

    @Override
    protected void configureCodec(com.google.a.a.e.a a2, MediaCodec mediaCodec, j j2, MediaCrypto mediaCrypto) throws d.b {
        this.codecMaxValues = c.getCodecMaxValues(a2, j2, this.streamFormats);
        MediaFormat mediaFormat = c.getMediaFormat(j2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (A.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
    }

    @Override
    protected void onInputFormatChanged(j j2) throws d {
        super.onInputFormatChanged(j2);
        this.eventDispatcher.a(j2);
        this.pendingPixelWidthHeightRatio = c.getPixelWidthHeightRatio(j2);
        this.pendingRotationDegrees = c.getRotationDegrees(j2);
    }

    @Override
    protected void onQueueInputBuffer(com.google.a.a.b.e e2) {
        if (A.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (A.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        c.setVideoScalingMode(mediaCodec, this.scalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl, j j2, j j3) {
        return c.areAdaptationCompatible(j2, j3) && j3.l <= this.codecMaxValues.a && j3.m <= this.codecMaxValues.b && j3.i <= this.codecMaxValues.c && (bl || j2.l == j3.l && j2.m == j3.m);
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl) {
        if (bl) {
            this.skipOutputBuffer(mediaCodec, n2);
            return true;
        }
        if (!this.renderedFirstFrame) {
            if (A.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l5 = SystemClock.elapsedRealtime() * 1000L - l3;
        long l6 = l4 - l2 - l5;
        long l7 = System.nanoTime();
        long l8 = l7 + l6 * 1000L;
        long l9 = this.frameReleaseTimeHelper.a(l4, l8);
        l6 = (l9 - l7) / 1000L;
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2);
            return true;
        }
        if (A.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l9);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n2);
            return true;
        }
        return false;
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return l2 < -30000L;
    }

    private void skipOutputBuffer(MediaCodec mediaCodec, int n2) {
        y.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        y.a();
        ++this.decoderCounters.e;
    }

    private void dropOutputBuffer(MediaCodec mediaCodec, int n2) {
        y.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        y.a();
        ++this.decoderCounters.f;
        ++this.droppedFrames;
        ++this.consecutiveDroppedFrameCount;
        this.decoderCounters.g = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.g);
        if (this.droppedFrames == this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    private void renderOutputBuffer(MediaCodec mediaCodec, int n2) {
        this.maybeNotifyVideoSizeChanged();
        y.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        y.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    private void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        y.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l2);
        y.a();
        ++this.decoderCounters.d;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (A.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearLastReportedVideoSize() {
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
        this.lastReportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.lastReportedWidth != this.currentWidth || this.lastReportedHeight != this.currentHeight || this.lastReportedUnappliedRotationDegrees != this.currentUnappliedRotationDegrees || this.lastReportedPixelWidthHeightRatio != this.currentPixelWidthHeightRatio) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.lastReportedWidth = this.currentWidth;
            this.lastReportedHeight = this.currentHeight;
            this.lastReportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.lastReportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat getMediaFormat(j j2, a a2, boolean bl, int n2) {
        MediaFormat mediaFormat = j2.b();
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        if (a2.c != -1) {
            mediaFormat.setInteger("max-input-size", a2.c);
        }
        if (bl) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            c.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    private static a getCodecMaxValues(com.google.a.a.e.a a2, j j2, j[] jArray) throws d.b {
        int n2 = j2.l;
        int n3 = j2.m;
        int n4 = c.getMaxInputSize(j2);
        if (jArray.length == 1) {
            return new a(n2, n3, n4);
        }
        boolean bl = false;
        for (j j3 : jArray) {
            if (!c.areAdaptationCompatible(j2, j3)) continue;
            bl |= j3.l == -1 || j3.m == -1;
            n2 = Math.max(n2, j3.l);
            n3 = Math.max(n3, j3.m);
            n4 = Math.max(n4, c.getMaxInputSize(j3));
        }
        if (bl) {
            int n5 = n2;
            int n6 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n6).toString());
            Point point = c.getCodecMaxSize(a2, j2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, c.getMaxInputSize(j2.h, n2, n3));
                n6 = n2;
                int n7 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n6).append("x").append(n7).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    private static Point getCodecMaxSize(com.google.a.a.e.a a2, j j2) throws d.b {
        boolean bl = j2.m > j2.l;
        int n2 = bl ? j2.m : j2.l;
        int n3 = bl ? j2.l : j2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (A.a >= 21) {
                Point point = a2.a(bl ? n5 : n4, bl ? n4 : n5);
                float f3 = j2.n;
                if (!a2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = A.a(n4, 16) * 16) * (n5 = A.a(n5, 16) * 16) > com.google.a.a.e.d.b()) continue;
            return new Point(bl ? n5 : n4, bl ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(j j2) {
        if (j2.i != -1) {
            return j2.i;
        }
        return c.getMaxInputSize(j2.h, j2.l, j2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(A.d)) {
                    return -1;
                }
                n5 = A.a(n2, 16) * A.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static void setVideoScalingMode(MediaCodec mediaCodec, int n2) {
        mediaCodec.setVideoScalingMode(n2);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return A.a <= 22 && "foster".equals(A.b) && "NVIDIA".equals(A.c);
    }

    private static boolean areAdaptationCompatible(j j2, j j3) {
        return j2.h.equals(j3.h) && c.getRotationDegrees(j2) == c.getRotationDegrees(j3);
    }

    private static float getPixelWidthHeightRatio(j j2) {
        return j2.p == -1.0f ? 1.0f : j2.p;
    }

    private static int getRotationDegrees(j j2) {
        return j2.o == -1 ? 0 : j2.o;
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(MediaCodec mediaCodec, long l2, long l3) {
            if (this != c.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            c.this.maybeNotifyRenderedFirstFrame();
        }
    }

    private static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

