/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.nano;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface SphericalMetadataOuterClass {

    public static final class SphericalMetadata
    extends MessageNano {
        public static final int STEREO_FRAME_LAYOUT_MONO = 1;
        public static final int STEREO_FRAME_LAYOUT_TOP_BOTTOM = 2;
        public static final int STEREO_FRAME_LAYOUT_LEFT_RIGHT = 3;
        private static volatile SphericalMetadata[] _emptyArray;
        public int initialViewHeadingDegrees;
        public int initialViewPitchDegrees;
        public int initialViewRollDegrees;
        public int frameLayoutMode;
        public StereoMeshConfig mesh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SphericalMetadata[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SphericalMetadata[0];
                    }
                }
            }
            return _emptyArray;
        }

        public SphericalMetadata() {
            this.clear();
        }

        public SphericalMetadata clear() {
            this.initialViewHeadingDegrees = 0;
            this.initialViewPitchDegrees = 0;
            this.initialViewRollDegrees = 0;
            this.frameLayoutMode = 1;
            this.mesh = null;
            this.cachedSize = -1;
            return this;
        }

        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.initialViewHeadingDegrees != 0) {
                output.writeInt32(1, this.initialViewHeadingDegrees);
            }
            if (this.initialViewPitchDegrees != 0) {
                output.writeInt32(2, this.initialViewPitchDegrees);
            }
            if (this.initialViewRollDegrees != 0) {
                output.writeInt32(3, this.initialViewRollDegrees);
            }
            if (this.frameLayoutMode != 1) {
                output.writeInt32(4, this.frameLayoutMode);
            }
            if (this.mesh != null) {
                output.writeMessage(5, (MessageNano)this.mesh);
            }
            super.writeTo(output);
        }

        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.initialViewHeadingDegrees != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size((int)1, (int)this.initialViewHeadingDegrees);
            }
            if (this.initialViewPitchDegrees != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size((int)2, (int)this.initialViewPitchDegrees);
            }
            if (this.initialViewRollDegrees != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size((int)3, (int)this.initialViewRollDegrees);
            }
            if (this.frameLayoutMode != 1) {
                size += CodedOutputByteBufferNano.computeInt32Size((int)4, (int)this.frameLayoutMode);
            }
            if (this.mesh != null) {
                size += CodedOutputByteBufferNano.computeMessageSize((int)5, (MessageNano)this.mesh);
            }
            return size;
        }

        public SphericalMetadata mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block11: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block11;
                        return this;
                    }
                    case 8: {
                        this.initialViewHeadingDegrees = input.readInt32();
                        continue block11;
                    }
                    case 16: {
                        this.initialViewPitchDegrees = input.readInt32();
                        continue block11;
                    }
                    case 24: {
                        this.initialViewRollDegrees = input.readInt32();
                        continue block11;
                    }
                    case 32: {
                        int value = input.readInt32();
                        switch (value) {
                            case 1: 
                            case 2: 
                            case 3: {
                                this.frameLayoutMode = value;
                            }
                        }
                        continue block11;
                    }
                    case 42: 
                }
                if (this.mesh == null) {
                    this.mesh = new StereoMeshConfig();
                }
                input.readMessage((MessageNano)this.mesh);
            }
        }

        public static SphericalMetadata parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return (SphericalMetadata)MessageNano.mergeFrom((MessageNano)new SphericalMetadata(), (byte[])data);
        }

        public static SphericalMetadata parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new SphericalMetadata().mergeFrom(input);
        }
    }

    public static final class StereoMeshConfig
    extends MessageNano {
        private static volatile StereoMeshConfig[] _emptyArray;
        public Mesh leftEyeMesh;
        public Mesh rightEyeMesh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static StereoMeshConfig[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new StereoMeshConfig[0];
                    }
                }
            }
            return _emptyArray;
        }

        public StereoMeshConfig() {
            this.clear();
        }

        public StereoMeshConfig clear() {
            this.leftEyeMesh = null;
            this.rightEyeMesh = null;
            this.cachedSize = -1;
            return this;
        }

        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.leftEyeMesh != null) {
                output.writeMessage(1, (MessageNano)this.leftEyeMesh);
            }
            if (this.rightEyeMesh != null) {
                output.writeMessage(2, (MessageNano)this.rightEyeMesh);
            }
            super.writeTo(output);
        }

        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.leftEyeMesh != null) {
                size += CodedOutputByteBufferNano.computeMessageSize((int)1, (MessageNano)this.leftEyeMesh);
            }
            if (this.rightEyeMesh != null) {
                size += CodedOutputByteBufferNano.computeMessageSize((int)2, (MessageNano)this.rightEyeMesh);
            }
            return size;
        }

        public StereoMeshConfig mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block5;
                        return this;
                    }
                    case 10: {
                        if (this.leftEyeMesh == null) {
                            this.leftEyeMesh = new Mesh();
                        }
                        input.readMessage((MessageNano)this.leftEyeMesh);
                        continue block5;
                    }
                    case 18: 
                }
                if (this.rightEyeMesh == null) {
                    this.rightEyeMesh = new Mesh();
                }
                input.readMessage((MessageNano)this.rightEyeMesh);
            }
        }

        public static StereoMeshConfig parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return (StereoMeshConfig)MessageNano.mergeFrom((MessageNano)new StereoMeshConfig(), (byte[])data);
        }

        public static StereoMeshConfig parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new StereoMeshConfig().mergeFrom(input);
        }

        public static final class Mesh
        extends MessageNano {
            public static final int TRIANGLES = 0;
            public static final int TRIANGLE_STRIP = 1;
            private static volatile Mesh[] _emptyArray;
            public Vertex[] vertices;
            public int geometryType;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Mesh[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Mesh[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public Mesh() {
                this.clear();
            }

            public Mesh clear() {
                this.vertices = Vertex.emptyArray();
                this.geometryType = 0;
                this.cachedSize = -1;
                return this;
            }

            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.vertices != null && this.vertices.length > 0) {
                    for (int i = 0; i < this.vertices.length; ++i) {
                        Vertex element = this.vertices[i];
                        if (element == null) continue;
                        output.writeMessage(1, (MessageNano)element);
                    }
                }
                if (this.geometryType != 0) {
                    output.writeInt32(2, this.geometryType);
                }
                super.writeTo(output);
            }

            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.vertices != null && this.vertices.length > 0) {
                    for (int i = 0; i < this.vertices.length; ++i) {
                        Vertex element = this.vertices[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize((int)1, (MessageNano)element);
                    }
                }
                if (this.geometryType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size((int)2, (int)this.geometryType);
                }
                return size;
            }

            public Mesh mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block8;
                            return this;
                        }
                        case 10: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)10);
                            int i = this.vertices == null ? 0 : this.vertices.length;
                            Vertex[] newArray = new Vertex[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.vertices, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new Vertex();
                                input.readMessage((MessageNano)newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new Vertex();
                            input.readMessage((MessageNano)newArray[i]);
                            this.vertices = newArray;
                            continue block8;
                        }
                        case 16: 
                    }
                    int value = input.readInt32();
                    switch (value) {
                        case 0: 
                        case 1: {
                            this.geometryType = value;
                        }
                    }
                }
            }

            public static Mesh parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return (Mesh)MessageNano.mergeFrom((MessageNano)new Mesh(), (byte[])data);
            }

            public static Mesh parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Mesh().mergeFrom(input);
            }

            public static final class Vertex
            extends MessageNano {
                private static volatile Vertex[] _emptyArray;
                public float x;
                public float y;
                public float z;
                public float u;
                public float v;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static Vertex[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new Vertex[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public Vertex() {
                    this.clear();
                }

                public Vertex clear() {
                    this.x = 0.0f;
                    this.y = 0.0f;
                    this.z = 0.0f;
                    this.u = 0.0f;
                    this.v = 0.0f;
                    this.cachedSize = -1;
                    return this;
                }

                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (Float.floatToIntBits(this.x) != Float.floatToIntBits(0.0f)) {
                        output.writeFloat(1, this.x);
                    }
                    if (Float.floatToIntBits(this.y) != Float.floatToIntBits(0.0f)) {
                        output.writeFloat(2, this.y);
                    }
                    if (Float.floatToIntBits(this.z) != Float.floatToIntBits(0.0f)) {
                        output.writeFloat(3, this.z);
                    }
                    if (Float.floatToIntBits(this.u) != Float.floatToIntBits(0.0f)) {
                        output.writeFloat(4, this.u);
                    }
                    if (Float.floatToIntBits(this.v) != Float.floatToIntBits(0.0f)) {
                        output.writeFloat(5, this.v);
                    }
                    super.writeTo(output);
                }

                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (Float.floatToIntBits(this.x) != Float.floatToIntBits(0.0f)) {
                        size += CodedOutputByteBufferNano.computeFloatSize((int)1, (float)this.x);
                    }
                    if (Float.floatToIntBits(this.y) != Float.floatToIntBits(0.0f)) {
                        size += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.y);
                    }
                    if (Float.floatToIntBits(this.z) != Float.floatToIntBits(0.0f)) {
                        size += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.z);
                    }
                    if (Float.floatToIntBits(this.u) != Float.floatToIntBits(0.0f)) {
                        size += CodedOutputByteBufferNano.computeFloatSize((int)4, (float)this.u);
                    }
                    if (Float.floatToIntBits(this.v) != Float.floatToIntBits(0.0f)) {
                        size += CodedOutputByteBufferNano.computeFloatSize((int)5, (float)this.v);
                    }
                    return size;
                }

                public Vertex mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block8: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block8;
                                return this;
                            }
                            case 13: {
                                this.x = input.readFloat();
                                continue block8;
                            }
                            case 21: {
                                this.y = input.readFloat();
                                continue block8;
                            }
                            case 29: {
                                this.z = input.readFloat();
                                continue block8;
                            }
                            case 37: {
                                this.u = input.readFloat();
                                continue block8;
                            }
                            case 45: 
                        }
                        this.v = input.readFloat();
                    }
                }

                public static Vertex parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return (Vertex)MessageNano.mergeFrom((MessageNano)new Vertex(), (byte[])data);
                }

                public static Vertex parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new Vertex().mergeFrom(input);
                }
            }
        }
    }
}

