/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import com.google.vr.sdk.widgets.common.VrEventListener;
import com.google.vr.sdk.widgets.common.VrWidgetRenderer;
import com.google.vr.sdk.widgets.common.VrWidgetView;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoRenderer;
import java.io.IOException;

public class VrVideoView
extends VrWidgetView {
    private static final String TAG = VrVideoView.class.getSimpleName();
    private static final boolean DEBUG = false;
    private VrVideoPlayer videoPlayer;
    private VrVideoRenderer renderer;

    public VrVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VrVideoView(Context context) {
        super(context);
    }

    protected VrVideoRenderer createRenderer(Context context, VrWidgetRenderer.GLThreadScheduler glThreadScheduler, float xMetersPerPixel, float yMetersPerPixel, int screenRotation) {
        this.videoPlayer = new VrVideoPlayer(context);
        this.renderer = new VrVideoRenderer(this.videoPlayer, this.getContext(), glThreadScheduler, xMetersPerPixel, yMetersPerPixel, screenRotation);
        this.videoPlayer.setVideoTexturesListener(new VrVideoPlayer.VideoTexturesListener(){

            @Override
            public void onVideoTexturesReady() {
                VrVideoView.this.renderer.setSphericalMetadata(VrVideoView.this.videoPlayer.getMetadata());
            }
        });
        return this.renderer;
    }

    public void pauseRendering() {
        super.pauseRendering();
        this.pauseVideo();
    }

    public void loadVideo(Uri uri, Options options) throws IOException {
        this.videoPlayer.openUri(uri, options);
    }

    public void loadVideoFromAsset(String filename, Options options) throws IOException {
        this.videoPlayer.openAsset(filename, options);
    }

    public void setEventListener(VrVideoEventListener eventListener) {
        super.setEventListener((VrEventListener)eventListener);
        this.videoPlayer.setEventListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playVideo() {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().setPlayWhenReady(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseVideo() {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().setPlayWhenReady(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekTo(long positionMs) {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().seekTo(positionMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long duration;
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            duration = this.videoPlayer.getExoPlayer().getDuration();
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentPosition() {
        long position;
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            position = this.videoPlayer.getExoPlayer().getCurrentPosition();
        }
        return position;
    }

    public void setVolume(float volume) {
        this.videoPlayer.setVolume(volume);
    }

    public static class Options {
        private static final int FORMAT_START_MARKER = 0;
        public static final int FORMAT_DEFAULT = 1;
        public static final int FORMAT_HLS = 2;
        public static final int FORMAT_DASH = 3;
        private static final int FORMAT_END_MARKER = 4;
        public int inputFormat = 1;
        private static final int TYPE_START_MARKER = 0;
        public static final int TYPE_MONO = 1;
        public static final int TYPE_STEREO_OVER_UNDER = 2;
        private static final int TYPE_END_MARKER = 3;
        public int inputType = 1;

        public void validate() {
            int n;
            if (this.inputFormat <= 0 || this.inputFormat >= 4) {
                n = this.inputFormat;
                Log.e((String)TAG, (String)new StringBuilder(40).append("Invalid Options.inputFormat: ").append(n).toString());
                this.inputFormat = 1;
            }
            if (this.inputType <= 0 || this.inputFormat >= 3) {
                n = this.inputType;
                Log.e((String)TAG, (String)new StringBuilder(38).append("Invalid Options.inputType: ").append(n).toString());
                this.inputType = 1;
            }
        }
    }
}

