/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.util.Log;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SphericalMetadataParser {
    private static final String TAG = SphericalMetadataParser.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String INITIAL_HEADING = "InitialViewHeadingDegrees";
    private static final String INITIAL_PITCH = "InitialViewPitchDegrees";
    private static final String INITIAL_ROLL = "InitialViewRollDegrees";
    private static final String SPHERICAL = "Spherical";
    private static final String STITCHED = "Stitched";
    private static final String STITCHING_SOFTWARE = "StitchingSoftware";
    private static final String PROJECTION_TYPE = "ProjectionType";
    private static final String STEREO_MODE = "StereoMode";
    private static final String STEREO_MODE_MONO = "mono";
    private static final String STEREO_MODE_LEFT_RIGHT = "left-right";
    private static final String STEREO_MODE_TOP_BOTTOM = "top-bottom";

    public static SphericalMetadataOuterClass.SphericalMetadata parse(String xmlContents) {
        if (xmlContents == null) {
            return new SphericalMetadataOuterClass.SphericalMetadata();
        }
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((InputStream)new StringBufferInputStream(xmlContents), null);
            parser.nextTag();
            return SphericalMetadataParser.readFeed(parser);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return new SphericalMetadataOuterClass.SphericalMetadata();
        }
    }

    private static SphericalMetadataOuterClass.SphericalMetadata readFeed(XmlPullParser parser) throws XmlPullParserException, IOException {
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        while (parser.next() != 1) {
            String name;
            if (parser.getEventType() != 2) continue;
            int depth = 1;
            String text = "";
            while (depth > 0) {
                switch (parser.next()) {
                    case 2: {
                        ++depth;
                        break;
                    }
                    case 3: {
                        --depth;
                        break;
                    }
                    case 4: {
                        text = parser.getText();
                    }
                }
            }
            if (text == null) continue;
            block15 : switch (name = parser.getName()) {
                case "InitialViewHeadingDegrees": {
                    metadata.initialViewHeadingDegrees = Integer.parseInt(text);
                    break;
                }
                case "InitialViewPitchDegrees": {
                    metadata.initialViewPitchDegrees = Integer.parseInt(text);
                    break;
                }
                case "InitialViewRollDegrees": {
                    metadata.initialViewRollDegrees = Integer.parseInt(text);
                    break;
                }
                case "StereoMode": {
                    switch (text) {
                        case "top-bottom": {
                            metadata.frameLayoutMode = 2;
                            break block15;
                        }
                        case "left-right": {
                            Log.e((String)TAG, (String)"left-right videos are unsupported");
                        }
                    }
                    metadata.frameLayoutMode = 1;
                    break;
                }
                case "Spherical": 
                case "Stitched": 
                case "StitchingSoftware": 
                case "ProjectionType": {
                    break;
                }
                default: {
                    String string = String.valueOf(name);
                    Log.w((String)TAG, (String)(string.length() != 0 ? "Unknown name: ".concat(string) : new String("Unknown name: ")));
                }
            }
        }
        return metadata;
    }
}

