/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class SphericalMetadataMP4 {
    private static final String TAG = "SphericalMetadataMP4";
    private static final String[] METADATA_PATH = new String[]{"moov", "trak"};
    private static final String METADATA_ATOM = "uuid";
    private static final byte[] SPHERICAL_UUID = new byte[]{-1, -52, -126, 99, -8, 85, 74, -109, -120, 20, 88, 122, 2, 82, 31, -35};
    private static final String METADATA_ATOM_CHARSET = "UTF-8";
    private static final long MIN_ATOM_SIZE = 8L;
    private static final long ATOM_SIZE_64_BITS = 1L;

    public static String extract(InputStream stream) {
        if (stream == null) {
            Log.e((String)TAG, (String)"Failed to extract metadata string from mp4: no stream!");
            return null;
        }
        try {
            return SphericalMetadataMP4.extract(stream, 0, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to extract metadata string from mp4.", (Throwable)e);
            return null;
        }
    }

    private static String extract(InputStream stream, int depth, long size) throws IOException {
        if (depth > METADATA_PATH.length) {
            throw new IllegalArgumentException("Search depth exceeds expectations.");
        }
        int pos = 0;
        while ((long)pos < size || depth == 0) {
            byte[] sizeBytes = SphericalMetadataMP4.readBytes(stream, 4);
            pos += 4;
            if (sizeBytes == null) {
                if (depth == 0) break;
                int n = pos;
                throw new IOException(new StringBuilder(69).append("Unexpected end of stream.").append(n).append(" ").append(size).append(" ").append(depth).toString());
            }
            long atomSize = SphericalMetadataMP4.bytesToInt(sizeBytes, 4);
            if (atomSize < 8L && atomSize != 1L) {
                long l = atomSize;
                throw new IOException(new StringBuilder(39).append("Invalid atom size: ").append(l).toString());
            }
            byte[] nameBytes = SphericalMetadataMP4.readBytes(stream, 4);
            pos += 4;
            if (nameBytes == null) {
                throw new IOException("Unexpected end of stream.");
            }
            String atomName = SphericalMetadataMP4.bytesToString(nameBytes, METADATA_ATOM_CHARSET);
            if (atomName == null || atomName.length() != 4) {
                throw new IOException("Invalid atom name.");
            }
            long bytesToEnd = atomSize - 8L;
            if (atomSize == 1L) {
                sizeBytes = SphericalMetadataMP4.readBytes(stream, 8);
                pos += 8;
                if (sizeBytes == null) {
                    throw new IOException("Unexpected end of stream.");
                }
                atomSize = SphericalMetadataMP4.bytesToInt(sizeBytes, 8);
                bytesToEnd = atomSize - 16L;
                if (atomSize < 8L) {
                    long l = atomSize;
                    throw new IOException(new StringBuilder(39).append("Invalid atom size: ").append(l).toString());
                }
            }
            if (depth != METADATA_PATH.length && METADATA_PATH[depth].equals(atomName)) {
                String result = SphericalMetadataMP4.extract(stream, depth + 1, atomSize - 8L);
                if (result != null) {
                    return result;
                }
                pos = (int)((long)pos + bytesToEnd);
                bytesToEnd = 0L;
            } else if (depth == METADATA_PATH.length && METADATA_ATOM.equals(atomName)) {
                byte[] uuid = SphericalMetadataMP4.readBytes(stream, SPHERICAL_UUID.length);
                pos += SPHERICAL_UUID.length;
                bytesToEnd -= (long)SPHERICAL_UUID.length;
                if (uuid == null) {
                    throw new IOException("Failed to parse UUID.");
                }
                if (Arrays.equals(uuid, SPHERICAL_UUID)) {
                    byte[] xmlBytes = SphericalMetadataMP4.readBytes(stream, (int)bytesToEnd);
                    String xmlString = SphericalMetadataMP4.bytesToString(xmlBytes, METADATA_ATOM_CHARSET);
                    if (xmlString == null) {
                        throw new IOException("Error retrieving metadata xml.");
                    }
                    String string = String.valueOf(xmlString);
                    Log.i((String)TAG, (String)(string.length() != 0 ? "Located spherical metadata:\n".concat(string) : new String("Located spherical metadata:\n")));
                    return xmlString;
                }
            }
            while (bytesToEnd > 0L) {
                long bytesSkipped = stream.skip(bytesToEnd);
                if (bytesSkipped <= 0L) continue;
                bytesToEnd -= bytesSkipped;
                pos = (int)((long)pos + bytesSkipped);
            }
        }
        return null;
    }

    private static byte[] readBytes(InputStream stream, int numBytes) throws IOException {
        int read;
        byte[] out = new byte[numBytes];
        for (int bytesRead = 0; bytesRead < numBytes; bytesRead += read) {
            read = stream.read(out, bytesRead, numBytes - bytesRead);
            if (read != -1) continue;
            return null;
        }
        return out;
    }

    private static long bytesToInt(byte[] bytes, int intBytes) {
        if (bytes == null || bytes.length != intBytes || intBytes > 8) {
            throw new IllegalArgumentException("Invalid byte array.");
        }
        int result = 0;
        for (int i = 0; i < intBytes; ++i) {
            result |= (bytes[i] & 0xFF) << 8 * (intBytes - 1 - i);
        }
        return result;
    }

    private static String bytesToString(byte[] bytes, String charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Null byte array.");
        }
        try {
            return new String(bytes, charset);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid charset.");
        }
    }
}

