/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.opengl.Matrix;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.Vector;

public class FrameRotationBuffer {
    private static final String TAG = "FrameRotationBuffer";
    private final float[] transform = new float[16];
    private final NavigableMap<Long, Vector<Float>> rotations = new TreeMap<Long, Vector<Float>>();

    public FrameRotationBuffer() {
        Matrix.setIdentityM((float[])this.transform, (int)0);
    }

    public synchronized void setRotation(long timestampUs, float[] angleAxis) {
        Vector<Float> vec = new Vector<Float>();
        for (int i = 0; i < 3; ++i) {
            vec.add(Float.valueOf(angleAxis[i]));
        }
        this.rotations.put(timestampUs, vec);
    }

    public synchronized float[] getTransform(long presentationTimeUs) {
        Map.Entry<Long, Vector<Float>> floorRotation = this.rotations.floorEntry(presentationTimeUs);
        if (floorRotation == null) {
            return this.transform;
        }
        this.rotations.headMap(floorRotation.getKey()).clear();
        Vector<Float> vec = floorRotation.getValue();
        FrameRotationBuffer.convertAngleAxisToTransformMatrix(vec.get(0).floatValue(), vec.get(1).floatValue(), vec.get(2).floatValue(), this.transform);
        return this.transform;
    }

    private static void convertAngleAxisToTransformMatrix(float x, float y, float z, float[] transform) {
        float angle = Matrix.length((float)x, (float)y, (float)z);
        if (angle != 0.0f) {
            float degrees = (float)Math.toDegrees(angle);
            Matrix.setRotateM((float[])transform, (int)0, (float)degrees, (float)(-x / angle), (float)(-y / angle), (float)(z / angle));
        } else {
            Matrix.setIdentityM((float[])transform, (int)0);
        }
    }
}

