/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.SphericalMetadataMP4;
import com.google.vr.sdk.widgets.video.SphericalMetadataParser;
import com.google.vr.sdk.widgets.video.SphericalV2MetadataParser;
import com.google.vr.sdk.widgets.video.VideoTexture;
import com.google.vr.sdk.widgets.video.VrSimpleExoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoView;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VrVideoPlayer
implements AdaptiveMediaSourceEventListener,
ExtractorMediaSource.EventListener {
    private static final String TAG = VrVideoPlayer.class.getSimpleName();
    private static final String EXO_USER_AGENT = "Video Player Widget";
    private static final boolean DEBUG = false;
    private Handler mainHandler;
    private VrSimpleExoPlayer simpleExoPlayer;
    private VideoTexture[] videoTextures = new VideoTexture[0];
    private boolean isBuffering = false;
    private boolean isLooping;
    private Context context;
    private VrVideoEventListener eventListener;
    private VideoTexturesListener videoTexturesListener;
    private DataSource.Factory mediaDataSourceFactory;
    private float volume = 1.0f;
    private FrameRotationBuffer frameRotationBuffer;
    private float[] cameraRotationMatrix;
    private SphericalMetadataOuterClass.SphericalMetadata metadata;

    public VrVideoPlayer(Context context) {
        this.context = context;
        this.init(context);
    }

    private void init(Context context) {
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.simpleExoPlayer = new VrSimpleExoPlayer(context);
        this.simpleExoPlayer.setProjectionListener(new ProjectionDataListener());
        this.frameRotationBuffer = new FrameRotationBuffer();
        this.simpleExoPlayer.setFrameRotationBuffer(this.frameRotationBuffer);
        this.getExoPlayer().addListener((ExoPlayer.EventListener)new VideoLooperListener());
        this.getExoPlayer().setPlayWhenReady(true);
    }

    private void loadVideoIntoPlayer(Uri uri, VrVideoView.Options options) {
        if (options == null) {
            options = new VrVideoView.Options();
        } else {
            options.validate();
        }
        this.mediaDataSourceFactory = new DefaultDataSourceFactory(this.context, EXO_USER_AGENT);
        MediaSource mediaSource = this.buildMediaSource(uri, options);
        this.simpleExoPlayer.prepare(mediaSource);
        this.videoTextures = new VideoTexture[1];
        this.videoTextures[0] = new VideoTexture();
        this.videoTextures[0].setOnNewFrameListener(new NewFrameNotifier());
        if (this.videoTexturesListener != null) {
            this.videoTexturesListener.onVideoTexturesReady();
        }
        this.applyVolumeToPlayer();
    }

    private MediaSource buildMediaSource(Uri uri, VrVideoView.Options options) {
        if (options.inputFormat == 2) {
            return new HlsMediaSource(uri, this.mediaDataSourceFactory, this.mainHandler, (AdaptiveMediaSourceEventListener)this);
        }
        return new ExtractorMediaSource(uri, this.mediaDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), this.mainHandler, (ExtractorMediaSource.EventListener)this);
    }

    public void setEventListener(VrVideoEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void openAsset(String filename, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        this.metadata = options != null ? VrVideoPlayer.createMetadataFromOptions(options) : VrVideoPlayer.parseMetadataFromVideoInputStream(this.context.getAssets().open(filename));
        String string = String.valueOf(filename);
        Uri videoUri = Uri.parse((String)(string.length() != 0 ? "file:///android_asset/".concat(string) : new String("file:///android_asset/")));
        this.loadVideoIntoPlayer(videoUri, options);
    }

    public void openUri(Uri uri, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        if (options != null) {
            this.metadata = VrVideoPlayer.createMetadataFromOptions(options);
        } else {
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.startsWith("http")) {
                this.metadata = VrVideoPlayer.parseMetadataFromVideoInputStream(new FileInputStream(uri.getPath()));
            }
        }
        this.loadVideoIntoPlayer(uri, options);
    }

    public SphericalMetadataOuterClass.SphericalMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getMetadataBytes() {
        return SphericalMetadataOuterClass.SphericalMetadata.toByteArray((MessageNano)this.metadata);
    }

    public float[] getCameraRotationMatrix() {
        return this.cameraRotationMatrix;
    }

    public synchronized int[] bindTexture() {
        if (this.videoTextures.length == 0) {
            throw new IllegalStateException("openXXX() should be called successfully first.");
        }
        int[] textureIds = new int[this.videoTextures.length];
        for (int i = 0; i < this.videoTextures.length; ++i) {
            VideoTexture videoTexture = this.videoTextures[i];
            if (!videoTexture.getIsTextureSet()) {
                videoTexture.init();
            }
            Surface videoSurface = new Surface(videoTexture.getSurfaceTexture());
            this.simpleExoPlayer.setVideoSurface(videoSurface);
            this.getExoPlayer().seekTo(this.getExoPlayer().getCurrentPosition() + 1L);
            textureIds[i] = videoTexture.getTextureId();
        }
        return textureIds;
    }

    public synchronized boolean prepareFrame() {
        boolean isReady = this.videoTextures.length > 0;
        for (VideoTexture videoTexture : this.videoTextures) {
            if (videoTexture.getIsTextureSet()) {
                videoTexture.updateTexture();
                if (this.frameRotationBuffer == null) continue;
                long releaseTimeUs = videoTexture.getTimestamp() / 1000L;
                long presentationTimeUs = releaseTimeUs - this.simpleExoPlayer.getPresentationStartTimeUs();
                this.cameraRotationMatrix = this.frameRotationBuffer.getTransform(presentationTimeUs);
                continue;
            }
            isReady = false;
        }
        return isReady;
    }

    public synchronized void onViewDetach() {
        for (int i = 0; i < this.videoTextures.length; ++i) {
            this.simpleExoPlayer.setVideoSurface(null);
            this.videoTextures[i].release();
        }
    }

    public synchronized void shutdown() {
        this.getExoPlayer().stop();
        this.getExoPlayer().release();
        for (VideoTexture videoTexture : this.videoTextures) {
            videoTexture.release();
        }
    }

    public synchronized long getCurrentPositionMs() {
        return this.getExoPlayer().getCurrentPosition();
    }

    public ExoPlayer getExoPlayer() {
        return this.simpleExoPlayer;
    }

    public void setVideoTexturesListener(VideoTexturesListener videoTexturesListener) {
        this.videoTexturesListener = videoTexturesListener;
    }

    public synchronized void setVolume(float volume) {
        this.volume = volume;
        this.applyVolumeToPlayer();
    }

    private synchronized void applyVolumeToPlayer() {
        this.simpleExoPlayer.setVolume(this.volume);
    }

    private static SphericalMetadataOuterClass.SphericalMetadata createMetadataFromOptions(VrVideoView.Options options) {
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (options.inputType) {
            case 1: {
                metadata.frameLayoutMode = 1;
                break;
            }
            case 2: {
                metadata.frameLayoutMode = 2;
                break;
            }
            default: {
                int n = options.inputType;
                throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected options.inputType ").append(n).toString());
            }
        }
        return metadata;
    }

    private static SphericalMetadataOuterClass.SphericalMetadata parseMetadataFromVideoInputStream(InputStream videoInputStream) throws IOException {
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        String metadataString = SphericalMetadataMP4.extract(videoInputStream);
        metadata = SphericalMetadataParser.parse(metadataString);
        videoInputStream.close();
        return metadata;
    }

    public void onLoadError(IOException error) {
        int n = this.hashCode();
        String string = String.valueOf(error);
        Log.e((String)TAG, (String)new StringBuilder(58 + String.valueOf(string).length()).append(n).append("ExtractorMediaSource.EventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(error.toString());
        }
    }

    public void onLoadStarted(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs) {
    }

    public void onLoadError(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded, IOException error, boolean wasCanceled) {
        int n = this.hashCode();
        String string = String.valueOf(error);
        Log.e((String)TAG, (String)new StringBuilder(56 + String.valueOf(string).length()).append(n).append("AdaptiveMediaSourceEventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(error.toString());
        }
    }

    public void onLoadCanceled(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
    }

    public void onLoadCompleted(DataSpec dataSpec, int dataType, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
    }

    public void onUpstreamDiscarded(int trackType, long mediaStartTimeMs, long mediaEndTimeMs) {
    }

    public void onDownstreamFormatChanged(int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long mediaTimeMs) {
    }

    private class NewFrameNotifier
    implements VideoTexture.OnNewFrameListener,
    Runnable {
        private Handler mainHandler = new Handler(Looper.getMainLooper());

        private NewFrameNotifier() {
        }

        @Override
        public void onNewFrame() {
            this.mainHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onNewFrame();
            }
        }
    }

    private class ProjectionDataListener
    implements SphericalV2ProjectionDataListener {
        private ProjectionDataListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProjectionDataChanged(int stereoMode, byte[] projectionData) {
            VrVideoPlayer.this.metadata = SphericalV2MetadataParser.parse(stereoMode, projectionData);
            VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
            synchronized (vrVideoPlayer) {
                boolean isReady;
                boolean bl = isReady = VrVideoPlayer.this.videoTextures.length > 0;
                if (isReady && VrVideoPlayer.this.videoTexturesListener != null) {
                    VrVideoPlayer.this.videoTexturesListener.onVideoTexturesReady();
                }
            }
        }
    }

    private class VideoLooperListener
    implements ExoPlayer.EventListener {
        private VideoLooperListener() {
        }

        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        public void onPositionDiscontinuity() {
        }

        public void onTimelineChanged(Timeline timeline, Object manifest) {
        }

        public void onLoadingChanged(boolean isLoading) {
        }

        public void onPlayerError(ExoPlaybackException error) {
            int n = this.hashCode();
            Log.e((String)TAG, (String)new StringBuilder(25).append(n).append(".onPlayerError").toString(), (Throwable)error);
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onLoadError(error.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            if (playbackState == 2) {
                VrVideoPlayer.this.isBuffering = true;
            } else if (playbackState == 3) {
                if (VrVideoPlayer.this.isBuffering && VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.isBuffering = false;
                    VrVideoPlayer.this.eventListener.onLoadSuccess();
                }
            } else if (playWhenReady && playbackState == 4) {
                if (VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.eventListener.onCompletion();
                }
                if (VrVideoPlayer.this.isLooping) {
                    VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
                    synchronized (vrVideoPlayer) {
                        VrVideoPlayer.this.getExoPlayer().seekTo(0L);
                    }
                }
            }
        }
    }

    public static interface VideoTexturesListener {
        public void onVideoTexturesReady();
    }
}

