/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends SimpleExoPlayer {
    private CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(context, (TrackSelector)new DefaultTrackSelector(), (LoadControl)new DefaultLoadControl(), null, 0, 5000L);
    }

    public void setFrameRotationBuffer(FrameRotationBuffer frameRotationBuffer) {
        this.cameraMotionRenderer.setFrameRotationBuffer(frameRotationBuffer);
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener projectionListener) {
        this.videoRenderer.setProjectionListener(projectionListener);
    }

    public long getPresentationStartTimeUs() {
        return this.videoRenderer.getPresentationStartTimeUs();
    }

    protected void buildVideoRenderers(Context context, Handler mainHandler, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, int extensionRendererMode, VideoRendererEventListener eventListener, long allowedVideoJoiningTimeMs, ArrayList<Renderer> out) {
        this.videoRenderer = new SphericalV2MediaCodecVideoRenderer(context, mainHandler, drmSessionManager, eventListener, allowedVideoJoiningTimeMs);
        out.add((Renderer)this.videoRenderer);
    }

    protected void buildMetadataRenderers(Context context, Handler mainHandler, int extensionRendererMode, MetadataRenderer.Output output, ArrayList<Renderer> out) {
        super.buildMetadataRenderers(context, mainHandler, extensionRendererMode, output, out);
        this.cameraMotionRenderer = new CameraMotionMetadataRendererV2();
        out.add((Renderer)this.cameraMotionRenderer);
    }
}

