/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import com.google.vr.libraries.video.ProjectionMeshDecoderV2;
import com.google.vr.libraries.video.ProjectionScene;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;

public class SphericalV2MetadataParser {
    private static final String TAG = SphericalV2MetadataParser.class.getSimpleName();

    public static SphericalMetadataOuterClass.SphericalMetadata parse(int stereoMode, byte[] projectionData) {
        ProjectionMeshDecoderV2 decoder = new ProjectionMeshDecoderV2();
        ProjectionScene scene = decoder.decode(projectionData);
        SphericalMetadataOuterClass.SphericalMetadata metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (stereoMode) {
            case 0: {
                metadata.frameLayoutMode = 1;
                break;
            }
            case 1: {
                metadata.frameLayoutMode = 2;
                break;
            }
            case 2: {
                metadata.frameLayoutMode = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(33).append("Unexpected stereoMode ").append(stereoMode).toString());
            }
        }
        metadata.mesh = new SphericalMetadataOuterClass.StereoMeshConfig();
        metadata.mesh.leftEyeMesh = SphericalV2MetadataParser.createMesh(scene.getLeftMesh());
        metadata.mesh.rightEyeMesh = SphericalV2MetadataParser.createMesh(scene.getRightMesh());
        return metadata;
    }

    private static SphericalMetadataOuterClass.StereoMeshConfig.Mesh createMesh(ProjectionScene.Mesh sceneMesh) {
        if (sceneMesh == null) {
            return null;
        }
        if (sceneMesh.getSubMeshCount() != 1) {
            throw new IllegalArgumentException("There should be only a single submesh");
        }
        ProjectionScene.SubMesh subMesh = sceneMesh.getSubMesh(0);
        SphericalMetadataOuterClass.StereoMeshConfig.Mesh mesh = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh();
        switch (subMesh.getMode()) {
            case 5: {
                mesh.geometryType = 1;
                break;
            }
            case 4: {
                mesh.geometryType = 0;
                break;
            }
            default: {
                int n = subMesh.getMode();
                throw new IllegalArgumentException(new StringBuilder(32).append("Unexpected mesh mode ").append(n).toString());
            }
        }
        float[] vertexArray = subMesh.getVertices();
        float[] coordArray = subMesh.getTextureCoords();
        int numVertices = vertexArray.length / 3;
        mesh.vertices = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex vertex;
            mesh.vertices[i] = vertex = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex();
            vertex.x = vertexArray[3 * i];
            vertex.y = vertexArray[3 * i + 1];
            vertex.z = vertexArray[3 * i + 2];
            vertex.u = coordArray[2 * i];
            vertex.v = coordArray[2 * i + 1];
        }
        return mesh;
    }
}

