/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.video.MediaCodecVideoRenderer;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import java.nio.ByteBuffer;

public class SphericalV2MediaCodecVideoRenderer
extends MediaCodecVideoRenderer {
    private static final int MAX_DROPPED_FRAME_COUNT_TO_NOTIFY = 1;
    private static final String TAG = SphericalV2MediaCodecVideoRenderer.class.getSimpleName();
    private long presentationStartTimeUs = 0L;
    private SphericalV2ProjectionDataListener projectionListener;

    public SphericalV2MediaCodecVideoRenderer(Context context, Handler mainHandler, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, VideoRendererEventListener eventListener, long allowedVideoJoiningTimeMs) {
        super(context, MediaCodecSelector.DEFAULT, allowedVideoJoiningTimeMs, drmSessionManager, false, mainHandler, eventListener, 1);
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener projectionListener) {
        this.projectionListener = projectionListener;
    }

    public long getPresentationStartTimeUs() {
        return this.presentationStartTimeUs;
    }

    protected void onInputFormatChanged(Format format) throws ExoPlaybackException {
        super.onInputFormatChanged(format);
        if (format != null && format.stereoMode != -1 && format.projectionData != null && this.projectionListener != null) {
            this.projectionListener.onProjectionDataChanged(format.stereoMode, format.projectionData);
        }
    }

    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, int bufferIndex, int bufferFlags, long bufferPresentationTimeUs, boolean shouldSkip) {
        long elapsedSinceStartOfLoopUs = SystemClock.elapsedRealtime() * 1000L - elapsedRealtimeUs;
        long earlyUs = bufferPresentationTimeUs - positionUs - elapsedSinceStartOfLoopUs;
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + earlyUs * 1000L;
        this.presentationStartTimeUs = unadjustedFrameReleaseTimeNs / 1000L - bufferPresentationTimeUs;
        return super.processOutputBuffer(positionUs, elapsedRealtimeUs, codec, buffer, bufferIndex, bufferFlags, bufferPresentationTimeUs, shouldSkip);
    }
}

