/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.vr.libraries.video.ProjectionScene;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ProjectionMeshDecoderV2 {
    private static final int TYPE_YTMP = Util.getIntegerCodeForString((String)"ytmp");
    private static final int TYPE_MSHP = Util.getIntegerCodeForString((String)"mshp");
    private static final int TYPE_RAW = Util.getIntegerCodeForString((String)"raw ");
    private static final int TYPE_DFL8 = Util.getIntegerCodeForString((String)"dfl8");
    private static final int TYPE_MESH = Util.getIntegerCodeForString((String)"mesh");
    private static final int TYPE_PROJ = Util.getIntegerCodeForString((String)"proj");
    private static final int MAX_MESH_COUNT = 2;
    private static final int MAX_COORDINATE_COUNT = 10000;
    private static final int MAX_VERTEX_COUNT = 32000;
    private static final int MAX_TRIANGLE_INDICES = 128000;
    private static final int INITIAL_DECOMPRESS_SIZE = 100000;
    private List<ProjectionScene> sceneList = new ArrayList<ProjectionScene>();
    private boolean error;
    private ProjectionScene scene;
    private int meshCount;
    private boolean ytmpParsed;

    public ProjectionScene decode(byte[] projectionData) {
        if (projectionData == null) {
            return null;
        }
        this.error = false;
        this.ytmpParsed = false;
        this.scene = null;
        ParsableByteArray input = new ParsableByteArray(projectionData);
        if (this.isProj(input)) {
            return this.parseProj(input);
        }
        return this.parseYtmp(input, input.capacity());
    }

    private boolean isProj(ParsableByteArray input) {
        int position = input.getPosition();
        input.setPosition(0);
        input.skipBytes(4);
        int type = input.readInt();
        input.setPosition(position);
        return type == TYPE_PROJ;
    }

    private ProjectionScene parseProj(ParsableByteArray input) {
        int childAtomSize;
        input.skipBytes(8);
        for (int position = input.getPosition(); position < input.capacity() && !this.error; position += childAtomSize) {
            input.setPosition(position);
            childAtomSize = input.readInt();
            if (childAtomSize == 0) {
                return null;
            }
            int childAtomType = input.readInt();
            if (childAtomType != TYPE_YTMP && childAtomType != TYPE_MSHP) continue;
            if (this.ytmpParsed) {
                return null;
            }
            ProjectionScene sceneReturned = this.parseYtmp(input, childAtomSize + position);
            if (this.error) {
                return null;
            }
            if (sceneReturned == null) continue;
            return sceneReturned;
        }
        return null;
    }

    private boolean readFromCache(int crc) {
        for (int i = 0; i < this.sceneList.size(); ++i) {
            if (this.sceneList.get(i).getCrc() != crc) continue;
            this.scene = this.sceneList.get(i);
            return true;
        }
        return false;
    }

    private ProjectionScene parseYtmp(ParsableByteArray input, int endOfBoxPosition) {
        int version = input.readUnsignedByte();
        input.skipBytes(3);
        if (version == 0) {
            int crc = input.readInt();
            if (this.readFromCache(crc)) {
                return this.scene;
            }
            int encoding = input.readInt();
            if (encoding == TYPE_RAW) {
                this.parseRawYtmpData(input, endOfBoxPosition, crc);
                this.ytmpParsed = true;
            } else if (encoding == TYPE_DFL8) {
                int[] outputLen = new int[1];
                byte[] rawData = ProjectionMeshDecoderV2.inflate(input.data, input.getPosition(), endOfBoxPosition - input.getPosition(), outputLen);
                if (rawData == null) {
                    return null;
                }
                ParsableByteArray rawInput = new ParsableByteArray(rawData, outputLen[0]);
                this.parseRawYtmpData(rawInput, outputLen[0], crc);
                this.ytmpParsed = true;
            } else {
                this.error = true;
            }
            if (this.error) {
                return null;
            }
            if (this.scene.getLeftMesh() != null) {
                this.sceneList.add(this.scene);
                return this.scene;
            }
        }
        return null;
    }

    private void parseRawYtmpData(ParsableByteArray input, int endOfBoxPosition, int crc) {
        int childAtomSize;
        this.meshCount = 0;
        this.scene = new ProjectionScene(crc);
        for (int position = input.getPosition(); position < endOfBoxPosition && !this.error; position += childAtomSize) {
            input.setPosition(position);
            childAtomSize = input.readInt();
            if (childAtomSize == 0) {
                this.error = true;
                return;
            }
            int childAtomType = input.readInt();
            if (childAtomType != TYPE_MESH) continue;
            if (this.meshCount >= 2) {
                this.error = true;
                return;
            }
            this.parseMesh(input);
            ++this.meshCount;
        }
    }

    private void parseMesh(ParsableByteArray input) {
        int coordinateCount = input.readInt();
        if (coordinateCount > 10000) {
            this.error = true;
            return;
        }
        float[] coordinates = new float[coordinateCount];
        int counter = 0;
        while (counter < coordinateCount) {
            coordinates[counter++] = input.readFloat();
        }
        int vertexCount = input.readInt();
        if (vertexCount > 32000) {
            this.error = true;
            return;
        }
        double log2 = Math.log(2.0);
        int coordinateCountSizeBits = (int)Math.ceil(Math.log(2.0 * (double)coordinateCount) / log2);
        counter = 0;
        int xIndex = 0;
        int yIndex = 0;
        int zIndex = 0;
        int uIndex = 0;
        int vIndex = 0;
        ParsableBitArray bitInput = new ParsableBitArray(input.data);
        bitInput.setPosition(input.getPosition() * 8);
        float[] vertices = new float[vertexCount * 5];
        int vertexId = 0;
        while (counter++ < vertexCount) {
            if (ProjectionMeshDecoderV2.isVertexInvalid(xIndex += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(coordinateCountSizeBits)), yIndex += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(coordinateCountSizeBits)), zIndex += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(coordinateCountSizeBits)), uIndex += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(coordinateCountSizeBits)), vIndex += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(coordinateCountSizeBits)), coordinateCount)) {
                this.error = true;
                return;
            }
            vertices[vertexId++] = coordinates[xIndex];
            vertices[vertexId++] = coordinates[yIndex];
            vertices[vertexId++] = coordinates[zIndex];
            vertices[vertexId++] = coordinates[uIndex];
            vertices[vertexId++] = coordinates[vIndex];
        }
        bitInput.setPosition(bitInput.getPosition() + 7 & 0xFFFFFFF8);
        bitInput.readBits(32);
        bitInput.readBits(8);
        int mode = bitInput.readBits(8);
        int triangleIndexCount = bitInput.readBits(32);
        if (triangleIndexCount > 128000) {
            this.error = true;
            return;
        }
        int vertexCountSizeBits = (int)Math.ceil(Math.log(2.0 * (double)vertexCount) / log2);
        int index = 0;
        float[] triangleVertices = new float[triangleIndexCount * 3];
        float[] textureCoords = new float[triangleIndexCount * 2];
        for (counter = 0; counter < triangleIndexCount; ++counter) {
            if ((index += ProjectionMeshDecoderV2.decodeZigZag(bitInput.readBits(vertexCountSizeBits))) >= vertexCount) {
                this.error = true;
                return;
            }
            triangleVertices[counter * 3] = vertices[index * 5];
            triangleVertices[counter * 3 + 1] = vertices[index * 5 + 1];
            triangleVertices[counter * 3 + 2] = vertices[index * 5 + 2];
            textureCoords[counter * 2] = vertices[index * 5 + 3];
            textureCoords[counter * 2 + 1] = vertices[index * 5 + 4];
        }
        int glDrawMode = 4;
        switch (mode) {
            case 1: {
                glDrawMode = 5;
                break;
            }
            case 2: {
                glDrawMode = 6;
                break;
            }
        }
        ProjectionScene.Mesh mesh = new ProjectionScene.Mesh();
        ProjectionScene.SubMesh subMesh = new ProjectionScene.SubMesh(triangleVertices, textureCoords, glDrawMode);
        mesh.addSubMesh(subMesh);
        if (this.meshCount == 0) {
            this.scene.setLeftMesh(mesh);
        } else if (this.meshCount == 1) {
            this.scene.setRightMesh(mesh);
        }
    }

    private static int decodeZigZag(int n) {
        return n >> 1 ^ -(n & 1);
    }

    private static boolean isVertexInvalid(int x, int y, int z, int u, int v, int limit) {
        return Math.max(Math.max(x, y), Math.max(z, u)) >= limit || v >= limit;
    }

    static byte[] inflate(byte[] input, int offset, int len, int[] outputLen) {
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(input, offset, len);
        int outputSize = 100000;
        byte[] output = new byte[outputSize];
        int decodedLength = 0;
        boolean needBiggerBuffer = false;
        try {
            do {
                decodedLength += decompresser.inflate(output, decodedLength, outputSize - decodedLength);
                boolean bl = needBiggerBuffer = !decompresser.needsInput();
                if (!needBiggerBuffer) continue;
                output = ProjectionMeshDecoderV2.resizeBuffer(output);
                outputSize = output.length;
            } while (needBiggerBuffer);
        }
        catch (DataFormatException e) {
            return null;
        }
        outputLen[0] = decodedLength;
        return output;
    }

    private static byte[] resizeBuffer(byte[] input) {
        byte[] output = new byte[input.length * 2];
        System.arraycopy(input, 0, output, 0, input.length);
        return output;
    }
}

