/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.util.Log;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.vr.libraries.video.FrameRotationBuffer;
import java.io.IOException;

public final class CameraMotionMetadataRendererV2
extends BaseRenderer {
    private static final String TAG = "CameraMotionMetadataRenderer";
    private final FormatHolder formatHolder = new FormatHolder();
    private final DecoderInputBuffer buffer = new DecoderInputBuffer(1);
    private FrameRotationBuffer frameRotationBuffer;
    private boolean inputStreamEnded = false;
    private boolean hasSample = false;

    public CameraMotionMetadataRendererV2() {
        super(4);
    }

    public void setFrameRotationBuffer(FrameRotationBuffer frameRotationBuffer) {
        this.frameRotationBuffer = frameRotationBuffer;
    }

    public int supportsFormat(Format format) {
        return format.sampleMimeType.equals("application/x-camera-motion") ? 3 : 0;
    }

    protected void onPositionReset(long positionUs, boolean joining) {
        this.hasSample = false;
        this.inputStreamEnded = false;
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.frameRotationBuffer == null) {
            throw new IllegalStateException("Callers must set the frame rotation buffer before rendering");
        }
        if (!this.inputStreamEnded && !this.hasSample) {
            this.buffer.clear();
            int result = this.readSource(this.formatHolder, this.buffer);
            if (result == -4) {
                if (this.buffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                    Log.d((String)TAG, (String)"stream ended");
                } else {
                    this.hasSample = true;
                }
            }
        }
        if (this.hasSample && this.buffer.timeUs <= positionUs + 100000L) {
            try {
                this.buffer.flip();
                this.frameRotationBuffer.setRotation(this.buffer.timeUs, CameraMotionMetadataRendererV2.parseMetadata(this.buffer.data.array(), this.buffer.data.limit()));
            }
            catch (IOException e) {
                throw ExoPlaybackException.createForRenderer((Exception)e, (int)this.getIndex());
            }
            this.hasSample = false;
        }
    }

    public boolean isEnded() {
        return this.inputStreamEnded;
    }

    public boolean isReady() {
        return true;
    }

    private static float[] parseMetadata(byte[] data, int size) throws IOException {
        ParsableByteArray parsable = new ParsableByteArray(data, size);
        float[] result = new float[3];
        parsable.skipBytes(4);
        result[0] = Float.intBitsToFloat(parsable.readLittleEndianInt());
        result[1] = Float.intBitsToFloat(parsable.readLittleEndianInt());
        result[2] = Float.intBitsToFloat(parsable.readLittleEndianInt());
        return result;
    }
}

