/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.cb;
import com.google.vr.sdk.widgets.video.deps.cd;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.gk;
import com.google.vr.sdk.widgets.video.deps.gl;
import com.google.vr.sdk.widgets.video.deps.gm;
import com.google.vr.sdk.widgets.video.deps.gn;
import com.google.vr.sdk.widgets.video.deps.go;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.op;
import com.google.vr.sdk.widgets.video.deps.pb;
import com.google.vr.sdk.widgets.video.deps.pq;
import com.google.vr.sdk.widgets.video.deps.ps;
import com.google.vr.sdk.widgets.video.deps.px;
import com.google.vr.sdk.widgets.video.deps.qa;
import com.google.vr.sdk.widgets.video.deps.qb;
import com.google.vr.sdk.widgets.video.deps.qd;
import java.nio.ByteBuffer;
import java.util.List;

@TargetApi(value=16)
public class pz
extends gl {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private static final float INITIAL_FORMAT_MAX_INPUT_SIZE_SCALE_FACTOR = 1.5f;
    private static boolean evaluatedDeviceNeedsSetOutputSurfaceWorkaround;
    private static boolean deviceNeedsSetOutputSurfaceWorkaround;
    private final Context context;
    private final qb frameReleaseTimeHelper;
    private final qd.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private final long[] pendingOutputStreamSwitchTimesUs;
    private a codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastRenderTimeUs;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long lastInputTimeUs;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;
    @Nullable
    private qa frameMetadataListener;

    public pz(Context context, gm gm2) {
        this(context, gm2, 0L);
    }

    public pz(Context context, gm gm2, long l2) {
        this(context, gm2, l2, null, null, -1);
    }

    public pz(Context context, gm gm2, long l2, @Nullable Handler handler, @Nullable qd qd2, int n2) {
        this(context, gm2, l2, null, false, handler, qd2, n2);
    }

    public pz(Context context, gm gm2, long l2, @Nullable cd<ch> cd2, boolean bl2, @Nullable Handler handler, @Nullable qd qd2, int n2) {
        super(2, gm2, cd2, bl2, 30.0f);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new qb(this.context);
        this.eventDispatcher = new qd.a(handler, qd2);
        this.deviceNeedsAutoFrcWorkaround = pz.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.pendingOutputStreamSwitchTimesUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(gm gm2, cd<ch> cd2, l l2) throws gn.b {
        List<gk> list;
        String string = l2.g;
        if (!pb.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        cb cb2 = l2.j;
        if (cb2 != null) {
            for (int i2 = 0; i2 < cb2.b; ++i2) {
                bl2 |= cb2.a((int)i2).d;
            }
        }
        if ((list = gm2.a(l2.g, bl2)).isEmpty()) {
            return bl2 && !gm2.a(l2.g, false).isEmpty() ? 2 : 1;
        }
        if (!pz.supportsFormatDrm(cd2, cb2)) {
            return 2;
        }
        gk gk2 = list.get(0);
        boolean bl3 = gk2.a(l2);
        int n2 = gk2.b(l2) ? 16 : 8;
        int n3 = gk2.e ? 32 : 0;
        int n4 = bl3 ? 4 : 3;
        return n2 | n3 | n4;
    }

    @Override
    protected void onEnabled(boolean bl2) throws f {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(l[] lArray, long l2) throws f {
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
            this.pendingOutputStreamSwitchTimesUs[this.pendingOutputStreamOffsetCount - 1] = this.lastInputTimeUs;
        }
        super.onStreamChanged(lArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws f {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        this.lastInputTimeUs = -9223372036854775807L;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws f {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                mediaCodec.setVideoScalingMode(this.scalingMode);
            }
        } else if (n2 == 6) {
            this.frameMetadataListener = (qa)object;
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws f {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                gk gk2 = this.getCodecInfo();
                if (gk2 != null && this.shouldUseDummySurface(gk2)) {
                    surface = this.dummySurface = px.a(this.context, gk2.f);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (ps.a >= 23 && mediaCodec != null && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    pz.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(gk gk2) {
        return this.surface != null || this.shouldUseDummySurface(gk2);
    }

    @Override
    protected boolean getCodecNeedsEosPropagation() {
        return this.tunneling;
    }

    @Override
    protected void configureCodec(gk gk2, MediaCodec mediaCodec, l l2, MediaCrypto mediaCrypto, float f2) throws gn.b {
        this.codecMaxValues = this.getCodecMaxValues(gk2, l2, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(l2, this.codecMaxValues, f2, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            op.b(this.shouldUseDummySurface(gk2));
            if (this.dummySurface == null) {
                this.dummySurface = px.a(this.context, gk2.f);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (ps.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected int canKeepCodec(MediaCodec mediaCodec, gk gk2, l l2, l l3) {
        if (gk2.a(l2, l3) && l3.l <= this.codecMaxValues.a && l3.m <= this.codecMaxValues.b && pz.getMaxInputSize(gk2, l3) <= this.codecMaxValues.c) {
            return l2.b(l3) ? 1 : 3;
        }
        return 0;
    }

    @Override
    @CallSuper
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            this.buffersInCodecCount = 0;
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    @CallSuper
    protected void flushCodec() throws f {
        super.flushCodec();
        this.buffersInCodecCount = 0;
    }

    @Override
    protected float getCodecOperatingRate(float f2, l l2, l[] lArray) {
        float f3 = -1.0f;
        for (l l3 : lArray) {
            float f4 = l3.n;
            if (f4 == -1.0f) continue;
            f3 = Math.max(f3, f4);
        }
        return f3 == -1.0f ? -1.0f : f3 * f2;
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
        this.codecNeedsSetOutputSurfaceWorkaround = this.codecNeedsSetOutputSurfaceWorkaround(string);
    }

    @Override
    protected void onInputFormatChanged(l l2) throws f {
        super.onInputFormatChanged(l2);
        this.eventDispatcher.a(l2);
        this.pendingPixelWidthHeightRatio = l2.p;
        this.pendingRotationDegrees = l2.o;
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(bo bo2) {
        ++this.buffersInCodecCount;
        this.lastInputTimeUs = Math.max(bo2.c, this.lastInputTimeUs);
        if (ps.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (ps.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        mediaCodec.setVideoScalingMode(this.scalingMode);
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2, l l5) throws f {
        boolean bl3;
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = l2;
        }
        long l6 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l6);
            return true;
        }
        long l7 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (pz.isBufferLate(l7)) {
                this.skipOutputBuffer(mediaCodec, n2, l6);
                return true;
            }
            return false;
        }
        long l8 = SystemClock.elapsedRealtime() * 1000L;
        boolean bl4 = bl3 = this.getState() == 2;
        if (!this.renderedFirstFrame || bl3 && this.shouldForceRenderOutputBuffer(l7, l8 - this.lastRenderTimeUs)) {
            long l9 = System.nanoTime();
            this.notifyFrameMetadataListener(l6, l9, l5);
            if (ps.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l6, l9);
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l6);
            }
            return true;
        }
        if (!bl3 || l2 == this.initialPositionUs) {
            return false;
        }
        long l10 = l8 - l3;
        l7 -= l10;
        long l11 = System.nanoTime();
        long l12 = l11 + l7 * 1000L;
        long l13 = this.frameReleaseTimeHelper.a(l4, l12);
        l7 = (l13 - l11) / 1000L;
        if (this.shouldDropBuffersToKeyframe(l7, l3) && this.maybeDropBuffersToKeyframe(mediaCodec, n2, l6, l2)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(l7, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l6);
            return true;
        }
        if (ps.a >= 21) {
            if (l7 < 50000L) {
                this.notifyFrameMetadataListener(l6, l13, l5);
                this.renderOutputBufferV21(mediaCodec, n2, l6, l13);
                return true;
            }
        } else if (l7 < 30000L) {
            if (l7 > 11000L) {
                try {
                    Thread.sleep((l7 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.notifyFrameMetadataListener(l6, l13, l5);
            this.renderOutputBuffer(mediaCodec, n2, l6);
            return true;
        }
        return false;
    }

    private void notifyFrameMetadataListener(long l2, long l3, l l4) {
        if (this.frameMetadataListener != null) {
            this.frameMetadataListener.a(l2, l3, l4);
        }
    }

    protected long getOutputStreamOffsetUs() {
        return this.outputStreamOffsetUs;
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long l2) {
        --this.buffersInCodecCount;
        while (this.pendingOutputStreamOffsetCount != 0 && l2 >= this.pendingOutputStreamSwitchTimesUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamSwitchTimesUs, 1, this.pendingOutputStreamSwitchTimesUs, 0, this.pendingOutputStreamOffsetCount);
        }
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return pz.isBufferLate(l2);
    }

    protected boolean shouldDropBuffersToKeyframe(long l2, long l3) {
        return pz.isBufferVeryLate(l2);
    }

    protected boolean shouldForceRenderOutputBuffer(long l2, long l3) {
        return pz.isBufferLate(l2) && l3 > 100000L;
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        pq.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        pq.a();
        ++this.decoderCounters.f;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        pq.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        pq.a();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec mediaCodec, int n2, long l2, long l3) throws f {
        int n3 = this.skipSource(l3);
        if (n3 == 0) {
            return false;
        }
        ++this.decoderCounters.i;
        this.updateDroppedBufferCounters(this.buffersInCodecCount + n3);
        this.flushCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int n2) {
        this.decoderCounters.g += n2;
        this.droppedFrames += n2;
        this.consecutiveDroppedFrameCount += n2;
        this.decoderCounters.h = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.h);
        if (this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        pq.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        pq.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        pq.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        pq.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(gk gk2) {
        return ps.a >= 23 && !this.tunneling && !this.codecNeedsSetOutputSurfaceWorkaround(gk2.a) && (!gk2.f || px.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (ps.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    private static boolean isBufferVeryLate(long l2) {
        return l2 < -500000L;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(l l2, a a2, float f2, boolean bl2, int n2) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", l2.g);
        mediaFormat.setInteger("width", l2.l);
        mediaFormat.setInteger("height", l2.m);
        go.a(mediaFormat, l2.i);
        go.a(mediaFormat, "frame-rate", l2.n);
        go.a(mediaFormat, "rotation-degrees", l2.o);
        go.a(mediaFormat, l2.s);
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        go.a(mediaFormat, "max-input-size", a2.c);
        if (ps.a >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (f2 != -1.0f) {
                mediaFormat.setFloat("operating-rate", f2);
            }
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            pz.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    protected a getCodecMaxValues(gk gk2, l l2, l[] lArray) throws gn.b {
        int n2 = l2.l;
        int n3 = l2.m;
        int n4 = pz.getMaxInputSize(gk2, l2);
        if (lArray.length == 1) {
            int n5;
            if (n4 != -1 && (n5 = pz.getCodecMaxInputSize(gk2, l2.g, l2.l, l2.m)) != -1) {
                int n6 = (int)((float)n4 * 1.5f);
                n4 = Math.min(n6, n5);
            }
            return new a(n2, n3, n4);
        }
        boolean bl2 = false;
        for (l l3 : lArray) {
            if (!gk2.a(l2, l3)) continue;
            bl2 |= l3.l == -1 || l3.m == -1;
            n2 = Math.max(n2, l3.l);
            n3 = Math.max(n3, l3.m);
            n4 = Math.max(n4, pz.getMaxInputSize(gk2, l3));
        }
        if (bl2) {
            int n7 = n2;
            int n8 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n7).append("x").append(n8).toString());
            Point point = pz.getCodecMaxSize(gk2, l2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, pz.getCodecMaxInputSize(gk2, l2.g, n2, n3));
                n8 = n2;
                int n9 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n8).append("x").append(n9).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    private static Point getCodecMaxSize(gk gk2, l l2) throws gn.b {
        boolean bl2 = l2.m > l2.l;
        int n2 = bl2 ? l2.m : l2.l;
        int n3 = bl2 ? l2.l : l2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (ps.a >= 21) {
                Point point = gk2.a(bl2 ? n5 : n4, bl2 ? n4 : n5);
                float f3 = l2.n;
                if (!gk2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = ps.a(n4, 16) * 16) * (n5 = ps.a(n5, 16) * 16) > gn.b()) continue;
            return new Point(bl2 ? n5 : n4, bl2 ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(gk gk2, l l2) {
        if (l2.h != -1) {
            int n2 = 0;
            int n3 = l2.i.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += l2.i.get(i2).length;
            }
            return l2.h + n2;
        }
        return pz.getCodecMaxInputSize(gk2, l2.g, l2.l, l2.m);
    }

    private static int getCodecMaxInputSize(gk gk2, String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(ps.d) || "Amazon".equals(ps.c) && ("KFSOWI".equals(ps.d) || "AFTS".equals(ps.d) && gk2.f)) {
                    return -1;
                }
                n5 = ps.a(n2, 16) * ps.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return ps.a <= 22 && "foster".equals(ps.b) && "NVIDIA".equals(ps.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean codecNeedsSetOutputSurfaceWorkaround(String string) {
        if (ps.a >= 27 || string.startsWith("OMX.google")) {
            return false;
        }
        Class<pz> clazz = pz.class;
        synchronized (pz.class) {
            if (!evaluatedDeviceNeedsSetOutputSurfaceWorkaround) {
                switch (ps.b) {
                    case "1601": 
                    case "1713": 
                    case "1714": 
                    case "A10-70F": 
                    case "A1601": 
                    case "A2016a40": 
                    case "A7000-a": 
                    case "A7000plus": 
                    case "A7010a48": 
                    case "A7020a48": 
                    case "AquaPowerM": 
                    case "Aura_Note_2": 
                    case "BLACK-1X": 
                    case "BRAVIA_ATV2": 
                    case "C1": 
                    case "ComioS1": 
                    case "CP8676_I02": 
                    case "CPH1609": 
                    case "CPY83_I00": 
                    case "cv1": 
                    case "cv3": 
                    case "deb": 
                    case "E5643": 
                    case "ELUGA_A3_Pro": 
                    case "ELUGA_Note": 
                    case "ELUGA_Prim": 
                    case "ELUGA_Ray_X": 
                    case "EverStar_S": 
                    case "F3111": 
                    case "F3113": 
                    case "F3116": 
                    case "F3211": 
                    case "F3213": 
                    case "F3215": 
                    case "F3311": 
                    case "flo": 
                    case "GiONEE_CBL7513": 
                    case "GiONEE_GBL7319": 
                    case "GIONEE_GBL7360": 
                    case "GIONEE_SWW1609": 
                    case "GIONEE_SWW1627": 
                    case "GIONEE_SWW1631": 
                    case "GIONEE_WBL5708": 
                    case "GIONEE_WBL7365": 
                    case "GIONEE_WBL7519": 
                    case "griffin": 
                    case "htc_e56ml_dtul": 
                    case "hwALE-H": 
                    case "HWBLN-H": 
                    case "HWCAM-H": 
                    case "HWVNS-H": 
                    case "iball8735_9806": 
                    case "Infinix-X572": 
                    case "iris60": 
                    case "itel_S41": 
                    case "j2xlteins": 
                    case "JGZ": 
                    case "K50a40": 
                    case "le_x6": 
                    case "LS-5017": 
                    case "M5c": 
                    case "manning": 
                    case "marino_f": 
                    case "MEIZU_M5": 
                    case "mh": 
                    case "mido": 
                    case "MX6": 
                    case "namath": 
                    case "nicklaus_f": 
                    case "NX541J": 
                    case "NX573J": 
                    case "OnePlus5T": 
                    case "p212": 
                    case "P681": 
                    case "P85": 
                    case "panell_d": 
                    case "panell_dl": 
                    case "panell_ds": 
                    case "panell_dt": 
                    case "PB2-670M": 
                    case "PGN528": 
                    case "PGN610": 
                    case "PGN611": 
                    case "Phantom6": 
                    case "Pixi4-7_3G": 
                    case "Pixi5-10_4G": 
                    case "PLE": 
                    case "PRO7S": 
                    case "Q350": 
                    case "Q4260": 
                    case "Q427": 
                    case "Q4310": 
                    case "Q5": 
                    case "QM16XE_U": 
                    case "QX1": 
                    case "santoni": 
                    case "Slate_Pro": 
                    case "SVP-DTV15": 
                    case "s905x018": 
                    case "taido_row": 
                    case "TB3-730F": 
                    case "TB3-730X": 
                    case "TB3-850F": 
                    case "TB3-850M": 
                    case "tcl_eu": 
                    case "V1": 
                    case "V23GB": 
                    case "V5": 
                    case "vernee_M5": 
                    case "watson": 
                    case "whyred": 
                    case "woods_f": 
                    case "woods_fn": 
                    case "X3_HK": 
                    case "XE2X": 
                    case "XT1663": 
                    case "Z12_PRO": 
                    case "Z80": {
                        deviceNeedsSetOutputSurfaceWorkaround = true;
                        break;
                    }
                }
                switch (ps.d) {
                    case "AFTA": 
                    case "AFTN": {
                        deviceNeedsSetOutputSurfaceWorkaround = true;
                        break;
                    }
                }
                evaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return deviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != pz.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            pz.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

