/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.CheckResult;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.vr.sdk.widgets.video.deps.bn;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.cc;
import com.google.vr.sdk.widgets.video.deps.cd;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.gk;
import com.google.vr.sdk.widgets.video.deps.gm;
import com.google.vr.sdk.widgets.video.deps.gn;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.m;
import com.google.vr.sdk.widgets.video.deps.op;
import com.google.vr.sdk.widgets.video.deps.pc;
import com.google.vr.sdk.widgets.video.deps.po;
import com.google.vr.sdk.widgets.video.deps.pq;
import com.google.vr.sdk.widgets.video.deps.ps;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class gl
extends com.google.vr.sdk.widgets.video.deps.a {
    protected static final float CODEC_OPERATING_RATE_UNSET = -1.0f;
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = ps.i("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final gm mediaCodecSelector;
    @Nullable
    private final cd<ch> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final float assumedMinimumCodecOperatingRate;
    private final bo buffer;
    private final bo flagsOnlyBuffer;
    private final m formatHolder;
    private final po<l> formatQueue;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private l format;
    private l pendingFormat;
    private l outputFormat;
    private cc<ch> drmSession;
    private cc<ch> pendingDrmSession;
    private MediaCodec codec;
    private float rendererOperatingRate;
    private float codecOperatingRate;
    private boolean codecConfiguredWithOperatingRate;
    @Nullable
    private ArrayDeque<gk> availableCodecInfos;
    @Nullable
    private a preferredDecoderInitializationException;
    @Nullable
    private gk codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private boolean codecNeedsEosPropagation;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private ByteBuffer outputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    protected bn decoderCounters;

    public gl(int n2, gm gm2, @Nullable cd<ch> cd2, boolean bl2, float f2) {
        super(n2);
        op.b(ps.a >= 16);
        this.mediaCodecSelector = op.a(gm2);
        this.drmSessionManager = cd2;
        this.playClearSamplesWithoutKeys = bl2;
        this.assumedMinimumCodecOperatingRate = f2;
        this.buffer = new bo(0);
        this.flagsOnlyBuffer = bo.e();
        this.formatHolder = new m();
        this.formatQueue = new po();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        this.codecOperatingRate = -1.0f;
        this.rendererOperatingRate = 1.0f;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(l l2) throws f {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, l2);
        }
        catch (gn.b b2) {
            throw f.a(b2, this.getIndex());
        }
    }

    protected abstract int supportsFormat(gm var1, cd<ch> var2, l var3) throws gn.b;

    protected List<gk> getDecoderInfos(gm gm2, l l2, boolean bl2) throws gn.b {
        return gm2.a(l2.g, bl2);
    }

    protected abstract void configureCodec(gk var1, MediaCodec var2, l var3, MediaCrypto var4, float var5) throws gn.b;

    protected final void maybeInitCodec() throws f {
        Object object;
        if (this.codec != null || this.format == null) {
            return;
        }
        this.drmSession = this.pendingDrmSession;
        String string = this.format.g;
        MediaCrypto mediaCrypto = null;
        boolean bl2 = false;
        if (this.drmSession != null) {
            object = this.drmSession.g();
            if (object == null) {
                cc.a a2 = this.drmSession.f();
                if (a2 == null) {
                    return;
                }
            } else {
                mediaCrypto = ((ch)object).a();
                bl2 = ((ch)object).a(string);
            }
            if (this.deviceNeedsDrmKeysToConfigureCodecWorkaround()) {
                int n2 = this.drmSession.e();
                if (n2 == 1) {
                    throw f.a(this.drmSession.f(), this.getIndex());
                }
                if (n2 != 4) {
                    return;
                }
            }
        }
        try {
            if (!this.initCodecWithFallback(mediaCrypto, bl2)) {
                return;
            }
        }
        catch (a a3) {
            throw f.a(a3, this.getIndex());
        }
        object = this.codecInfo.a;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode((String)object);
        this.codecNeedsDiscardToSpsWorkaround = gl.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = gl.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsEosFlushWorkaround = gl.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = gl.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = gl.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        this.codecNeedsEosPropagation = gl.codecNeedsEosPropagationWorkaround(this.codecInfo) || this.getCodecNeedsEosPropagation();
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        ++this.decoderCounters.a;
    }

    protected boolean shouldInitCodec(gk gk2) {
        return true;
    }

    protected boolean getCodecNeedsEosPropagation() {
        return false;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    @Nullable
    protected final gk getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean bl2) throws f {
        this.decoderCounters = new bn();
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws f {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
        this.formatQueue.a();
    }

    @Override
    public final void setOperatingRate(float f2) throws f {
        this.rendererOperatingRate = f2;
        this.updateCodecOperatingRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.format = null;
        this.availableCodecInfos = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.drmSession != null) {
                    this.drmSessionManager.a(this.drmSession);
                }
            }
            finally {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.a(this.pendingDrmSession);
                    }
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.resetCodecBuffers();
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecNeedsEosPropagation = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        this.codecConfiguredWithOperatingRate = false;
        if (this.codec != null) {
            ++this.decoderCounters.b;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                    if (this.drmSession != null && this.pendingDrmSession != this.drmSession) {
                        try {
                            this.drmSessionManager.a(this.drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long l2, long l3) throws f {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else {
                if (n2 == -4) {
                    op.b(this.flagsOnlyBuffer.c());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                    return;
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            pq.a("drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            pq.a();
        } else {
            this.decoderCounters.d += this.skipSource(l2);
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else if (n2 == -4) {
                op.b(this.flagsOnlyBuffer.c());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.a();
    }

    protected void flushCodec() throws f {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean initCodecWithFallback(MediaCrypto mediaCrypto, boolean bl2) throws a {
        if (this.availableCodecInfos == null) {
            try {
                this.availableCodecInfos = new ArrayDeque<gk>(this.getAvailableCodecInfos(bl2));
                this.preferredDecoderInitializationException = null;
            }
            catch (gn.b b2) {
                throw new a(this.format, (Throwable)b2, bl2, -49998);
            }
        }
        if (this.availableCodecInfos.isEmpty()) {
            throw new a(this.format, null, bl2, -49999);
        }
        gk gk2;
        while (this.shouldInitCodec(gk2 = this.availableCodecInfos.peekFirst())) {
            try {
                this.initCodec(gk2, mediaCrypto);
                return true;
            }
            catch (Exception exception) {
                Object object = String.valueOf(gk2);
                Log.w((String)TAG, (String)new StringBuilder(30 + String.valueOf(object).length()).append("Failed to initialize decoder: ").append((String)object).toString(), (Throwable)exception);
                this.availableCodecInfos.removeFirst();
                object = new a(this.format, (Throwable)exception, bl2, gk2.a);
                this.preferredDecoderInitializationException = this.preferredDecoderInitializationException == null ? object : this.preferredDecoderInitializationException.a((a)object);
                if (!this.availableCodecInfos.isEmpty()) continue;
                throw this.preferredDecoderInitializationException;
            }
            break;
        }
        return false;
    }

    private List<gk> getAvailableCodecInfos(boolean bl2) throws gn.b {
        List<gk> list = this.getDecoderInfos(this.mediaCodecSelector, this.format, bl2);
        if (list.isEmpty() && bl2 && !(list = this.getDecoderInfos(this.mediaCodecSelector, this.format, false)).isEmpty()) {
            String string = this.format.g;
            String string2 = String.valueOf(list);
            Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append(string2).append(".").toString());
        }
        return list;
    }

    private void initCodec(gk gk2, MediaCrypto mediaCrypto) throws Exception {
        long l2;
        long l3;
        MediaCodec mediaCodec = null;
        String string = gk2.a;
        this.updateCodecOperatingRate();
        boolean bl2 = this.codecOperatingRate > this.assumedMinimumCodecOperatingRate;
        try {
            l3 = SystemClock.elapsedRealtime();
            String string2 = String.valueOf(string);
            pq.a(string2.length() != 0 ? "createCodec:".concat(string2) : new String("createCodec:"));
            mediaCodec = MediaCodec.createByCodecName((String)string);
            pq.a();
            pq.a("configureCodec");
            this.configureCodec(gk2, mediaCodec, this.format, mediaCrypto, bl2 ? this.codecOperatingRate : -1.0f);
            this.codecConfiguredWithOperatingRate = bl2;
            pq.a();
            pq.a("startCodec");
            mediaCodec.start();
            pq.a();
            l2 = SystemClock.elapsedRealtime();
            this.getCodecBuffers(mediaCodec);
        }
        catch (Exception exception) {
            if (mediaCodec != null) {
                this.resetCodecBuffers();
                mediaCodec.release();
            }
            throw exception;
        }
        this.codec = mediaCodec;
        this.codecInfo = gk2;
        long l4 = l2 - l3;
        this.onCodecInitialized(string, l2, l4);
    }

    private void getCodecBuffers(MediaCodec mediaCodec) {
        if (ps.a < 21) {
            this.inputBuffers = mediaCodec.getInputBuffers();
            this.outputBuffers = mediaCodec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (ps.a < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int n2) {
        if (ps.a >= 21) {
            return this.codec.getInputBuffer(n2);
        }
        return this.inputBuffers[n2];
    }

    private ByteBuffer getOutputBuffer(int n2) {
        if (ps.a >= 21) {
            return this.codec.getOutputBuffer(n2);
        }
        return this.outputBuffers[n2];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.b = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private boolean feedInputBuffer() throws f {
        int n2;
        int n3;
        if (this.codec == null || this.codecReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.b = this.getInputBuffer(this.inputIndex);
            this.buffer.a();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagation) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.b.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        int n4 = 0;
        if (this.waitingForKeys) {
            n3 = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n2 = 0; n2 < this.format.i.size(); n2 += 1) {
                    byte[] byArray = this.format.i.get(n2);
                    this.buffer.b.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n4 = this.buffer.b.position();
            n3 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n3 == -3) {
            return false;
        }
        if (n3 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.a);
            return true;
        }
        if (this.buffer.c()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagation) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw f.a((Exception)((Object)cryptoException), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.d()) {
            this.buffer.a();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        n2 = this.buffer.g() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n2 != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n2) {
            pc.a(this.buffer.b);
            if (this.buffer.b.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.c;
            if (this.buffer.b_()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            if (this.pendingFormat != null) {
                this.formatQueue.a(l2, this.pendingFormat);
                this.pendingFormat = null;
            }
            this.buffer.h();
            this.onQueueInputBuffer(this.buffer);
            if (n2) {
                MediaCodec.CryptoInfo cryptoInfo = gl.getFrameworkCryptoInfo(this.buffer, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.b.limit(), l2, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.c;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw f.a((Exception)((Object)cryptoException), this.getIndex());
        }
        return true;
    }

    private boolean shouldWaitForKeys(boolean bl2) throws f {
        if (this.drmSession == null || !bl2 && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int n2 = this.drmSession.e();
        if (n2 == 1) {
            throw f.a(this.drmSession.f(), this.getIndex());
        }
        return n2 != 4;
    }

    protected void onCodecInitialized(String string, long l2, long l3) {
    }

    protected void onInputFormatChanged(l l2) throws f {
        boolean bl2;
        l l3 = this.format;
        this.format = l2;
        this.pendingFormat = l2;
        boolean bl3 = bl2 = !ps.a(this.format.j, (Object)(l3 == null ? null : l3.j));
        if (bl2) {
            if (this.format.j != null) {
                if (this.drmSessionManager == null) {
                    throw f.a(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                this.pendingDrmSession = this.drmSessionManager.a(Looper.myLooper(), this.format.j);
                if (this.pendingDrmSession == this.drmSession) {
                    this.drmSessionManager.a(this.pendingDrmSession);
                }
            } else {
                this.pendingDrmSession = null;
            }
        }
        boolean bl4 = false;
        if (this.pendingDrmSession == this.drmSession && this.codec != null) {
            switch (this.canKeepCodec(this.codec, this.codecInfo, l3, this.format)) {
                case 0: {
                    break;
                }
                case 1: {
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl4 = true;
                    this.codecReconfigured = true;
                    this.codecReconfigurationState = 1;
                    this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && this.format.l == l3.l && this.format.m == l3.m;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!bl4) {
            this.reinitializeCodec();
        } else {
            this.updateCodecOperatingRate();
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws f {
    }

    protected void onQueueInputBuffer(bo bo2) {
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected int canKeepCodec(MediaCodec mediaCodec, gk gk2, l l2, l l3) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    protected float getCodecOperatingRate(float f2, l l2, l[] lArray) {
        return -1.0f;
    }

    private void updateCodecOperatingRate() throws f {
        if (this.format == null || ps.a < 23) {
            return;
        }
        float f2 = this.getCodecOperatingRate(this.rendererOperatingRate, this.format, this.getStreamFormats());
        if (this.codecOperatingRate == f2) {
            return;
        }
        this.codecOperatingRate = f2;
        if (this.codec != null && this.codecReinitializationState == 0) {
            if (f2 == -1.0f && this.codecConfiguredWithOperatingRate) {
                this.reinitializeCodec();
            } else if (f2 != -1.0f && (this.codecConfiguredWithOperatingRate || f2 > this.assumedMinimumCodecOperatingRate)) {
                Bundle bundle = new Bundle();
                bundle.putFloat("operating-rate", f2);
                this.codec.setParameters(bundle);
                this.codecConfiguredWithOperatingRate = true;
            }
        }
    }

    private void reinitializeCodec() throws f {
        this.availableCodecInfos = null;
        if (this.codecReceivedBuffers) {
            this.codecReinitializationState = 1;
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    private boolean drainOutputBuffer(long l2, long l3) throws f {
        int n2;
        if (!this.hasOutputBuffer()) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (n2 < 0) {
                if (n2 == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (n2 == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagation && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
            if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                this.codec.releaseOutputBuffer(n2, false);
                return true;
            }
            if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                this.processEndOfStream();
                return false;
            }
            this.outputIndex = n2;
            this.outputBuffer = this.getOutputBuffer(n2);
            if (this.outputBuffer != null) {
                this.outputBuffer.position(this.outputBufferInfo.offset);
                this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
            }
            this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            l l4 = this.formatQueue.a(this.outputBufferInfo.presentationTimeUs);
            if (l4 != null) {
                this.outputFormat = l4;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer, this.outputFormat) ? 1 : 0;
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer, this.outputFormat) ? 1 : 0;
        }
        if (n2 != 0) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean bl2 = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!bl2) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputFormat() throws f {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void processOutputBuffersChanged() {
        if (ps.a < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11, l var12) throws f;

    protected void renderToEndOfStream() throws f {
    }

    private void processEndOfStream() throws f {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(bo bo2, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = bo2.a.a();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n2;
        return cryptoInfo;
    }

    private boolean deviceNeedsDrmKeysToConfigureCodecWorkaround() {
        return "Amazon".equals(ps.c) && ("AFTM".equals(ps.d) || "AFTB".equals(ps.d));
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return ps.a < 18 || ps.a == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || ps.a == 19 && ps.d.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private int codecAdaptationWorkaroundMode(String string) {
        if (ps.a <= 25 && "OMX.Exynos.avc.dec.secure".equals(string) && (ps.d.startsWith("SM-T585") || ps.d.startsWith("SM-A510") || ps.d.startsWith("SM-A520") || ps.d.startsWith("SM-J700"))) {
            return 2;
        }
        if (ps.a < 24 && ("OMX.Nvidia.h264.decode".equals(string) || "OMX.Nvidia.h264.decode.secure".equals(string)) && ("flounder".equals(ps.b) || "flounder_lte".equals(ps.b) || "grouper".equals(ps.b) || "tilapia".equals(ps.b))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, l l2) {
        return ps.a < 21 && l2.i.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(gk gk2) {
        String string = gk2.a;
        return ps.a <= 17 && ("OMX.rk.video_decoder.avc".equals(string) || "OMX.allwinner.video.decoder.avc".equals(string)) || "Amazon".equals(ps.c) && "AFTS".equals(ps.d) && gk2.f;
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return ps.a <= 23 && "OMX.google.vorbis.decoder".equals(string) || ps.a <= 19 && "hb2000".equals(ps.b) && ("OMX.amlogic.avc.decoder.awesome".equals(string) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string) {
        return ps.a == 21 && "OMX.google.aac.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, l l2) {
        return ps.a <= 18 && l2.t == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    public static class a
    extends Exception {
        public final String a;
        public final boolean b;
        public final String c;
        public final String d;
        @Nullable
        public final a e;

        public a(l l2, Throwable throwable, boolean bl2, int n2) {
            String string = String.valueOf(l2);
            this(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(n2).append("], ").append(string).toString(), throwable, l2.g, bl2, null, com.google.vr.sdk.widgets.video.deps.gl$a.a(n2), null);
        }

        public a(l l2, Throwable throwable, boolean bl2, String string) {
            String string2 = String.valueOf(l2);
            this(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), throwable, l2.g, bl2, string, ps.a >= 21 ? com.google.vr.sdk.widgets.video.deps.gl$a.a(throwable) : null, null);
        }

        private a(String string, Throwable throwable, String string2, boolean bl2, @Nullable String string3, @Nullable String string4, @Nullable a a2) {
            super(string, throwable);
            this.a = string2;
            this.b = bl2;
            this.c = string3;
            this.d = string4;
            this.e = a2;
        }

        @CheckResult
        private a a(a a2) {
            return new a(this.getMessage(), this.getCause(), this.a, this.b, this.c, this.d, a2);
        }

        @TargetApi(value=21)
        private static String a(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String a(int n2) {
            String string = n2 < 0 ? "neg_" : "";
            int n3 = Math.abs(n2);
            return new StringBuilder(64 + String.valueOf(string).length()).append("com.google.android.exoplayer.MediaCodecTrackRenderer_").append(string).append(n3).toString();
        }
    }
}

